package com.huawei.sis.demo.intl_demo;

import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisConstant;
import com.huawei.sis.bean.request.AsrCustomShortRequest;
import com.huawei.sis.bean.response.AsrCustomShortResponse;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.client.AsrCustomizationClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.IOUtils;

import java.util.List;

/**
 * Sentence transcription. Used for internation region.
 *
 * Copyright 2020 Huawei Technologies Co.,Ltd.
 */
public class AsrCustomizationDemo {
  // The ak and sk used for authentication are hard coded into the code or stored in plain text,
  // which has great security risks. You are advised to store them in ciphertext in the configuration
  // file or environment variable and decrypt them during use to ensure security.

  // In this demo code, ak and sk are stored in environment variables to implement authentication.
  // Before running this example, set environment variables HUAWEICLOUD_SDK_AK and HUAWEICLOUD_SDK_SK
  // in the local environment.
  private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
  private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
  private String region = "";    // region, such as ap-southeast-3
  private String projectId = ""; // project_id, refer to https://support.huaweicloud.com/intl/en-us/api-sis/sis_03_0008.html
 
  private String path = "";             // the file path，such as D:/test.wav. The sample rate should be same as pathProperty.
  private String pathAudioFormat = "";  // audio format，such as wav. Please refer to api document
  private String pathProperty = "";     // language_sampleRate_domain, such as english_8k_common. Please refer to api document


  /**
   * set the parameter, all the parameters are optional
   *
   * @param request sentence transcription request
   */
  private void setShortParameter(AsrCustomShortRequest request) {
    // set punctuation, yes or no, default no.
    request.setAddPunc("yes");
	// sentence transcription doesn't support hot word now. So the method of setVocabularyId makes no sense. 
  }

  /**
   * set config, all the parameters are optional
   *
   * @return SisConfig
   */
  private SisConfig getConfig() {
    SisConfig config = new SisConfig();
    // connect timeout，default 10000ms
    config.setConnectionTimeout(SisConstant.DEFAULT_CONNECTION_TIMEOUT);
    // request timeout, default 10000ms
    config.setRequestTimeout(SisConstant.DEFAULT_CONNECTION_REQUEST_TIMEOUT);
    // socket timeout, default 10000ms
    config.setSocketTimeout(SisConstant.DEFAULT_SOCKET_TIMEOUT);
    // set proxy, please make sure that it can take effects before use.
    // ProxyHostInfo proxy = new ProxyHostInfo(host, port, username, password);
    // config.setProxy(proxy);
    return config;
  }

  
  /**
   * print the result of sentence transcription。
   *
   * @param response response
   */
  private void printAsrShortResponse(AsrCustomShortResponse response) {
    System.out.println("traceId=" + response.getTraceId());
    System.out.println("text=" + response.getText());
    System.out.println("score=" + response.getScore());
    System.out.println("\n");
  }
  
  /**
   * sentence transcription demo。
   */
  private void shortDemo() {
    try {
 
      // 1. initialize AsrCustomizationClient
      AuthInfo authInfo = new AuthInfo(ak, sk, region, projectId);
      SisConfig config = getConfig();
      AsrCustomizationClient asr = new AsrCustomizationClient(authInfo, config);
 
      // 2. set parameters
      String data = IOUtils.getEncodeDataByPath(path);
      AsrCustomShortRequest request = new AsrCustomShortRequest(data, pathAudioFormat, pathProperty);
      // all parameters are optional
      setShortParameter(request);
 
      // 3. send request, get response
      AsrCustomShortResponse response = asr.getAsrShortResponse(request);
      // print result
      printAsrShortResponse(response);
 
    } catch (SisException e) {
      e.printStackTrace();
      System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
    }
  }


  public static void main(String[] args) {
    AsrCustomizationDemo demo = new AsrCustomizationDemo();
    //  sentence transcription
    demo.shortDemo();

  }

}
