package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisConstant;
import com.huawei.sis.bean.request.VcsCloneRequest;
import com.huawei.sis.bean.response.VoiceCloneResponse;
import com.huawei.sis.client.VcsClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 声音复刻Demo
 * <p>
 * Copyright 2021 Huawei Technologies Co.,Ltd.
 */
public class VcsDemo {

    private static final Logger log = LoggerFactory.getLogger(VcsDemo.class);

    // 认证用的ak和sk硬编码到代码中或者明文存储都有很大的安全风险，建议在配置文件或者环境变量中密文存放，使用时解密，确保安全；
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");

    private String region = "";    // 区域，如cn-east-3

    private String projectId = ""; // 项目id，在我的凭证查看。参考https://support.huaweicloud.com/api-sis/sis_03_0008.html

    private String serviceEndPoint = "";  // 可选参数,传入new AuthInfo(ak, sk, region, projectId);

    private String voiceName = ""; // 音色名称，可以使用注册音色或预置音色

    private String text = ""; //  待合成文本

    private String audioPath = "";  // 待合成结果保存路径,例如"D://SIS/audio.wav"
    // 使用该脚本前,保证要使用的声音已经注册,voiceName为声音名称。若没有注册声音,请使用VcsRegisterAndRequest.java脚本，注册声音和查询声音

    public static void main(String[] args) {
        VcsDemo demo = new VcsDemo();
        demo.vcsDemo();
    }

    /**
     * 定义config，所有参数可选，设置超时时间等。
     *
     * @return SisConfig
     */
    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        // 设置连接超时，默认10000ms
        config.setConnectionTimeout(SisConstant.DEFAULT_CONNECTION_TIMEOUT);
        // 设置读取超时，默认10000ms
        config.setReadTimeout(SisConstant.DEFAULT_READ_TIMEOUT);
        // 设置代理, 一定要确保代理可用才启动此设置。 代理初始化也可用不加密的代理，new ProxyHostInfo(host, port);
        // 设置代理，可参考 config.setProxy(new ProxyHostInfo(host, port, user, password));
        return config;
    }

    private void setParameters(VcsCloneRequest request) {
        // 1. 设置音频格式，默认wav
        request.getVoiceCloneConfig().setAudioFormat("wav");
        // 2. 设置采样率，24000、16000、8000，默认16000
        request.getVoiceCloneConfig().setSampleRate("16000");
        // 3. 设置音色，如 chinese_huaxiaoli_common、chinese_huaxiaotian_common
        request.getVoiceCloneConfig().setVoiceName(voiceName);
        // 4. 设置语速，取值范围为 -500~500，默认值为0
        request.getVoiceCloneConfig().setSpeed(0);
        // 5. 设置音调，取值范围为 -500~500，默认值为0
        request.getVoiceCloneConfig().setPitch(0);
        // 6. 设置音量，取值范围为 0~100，默认值为50
        request.getVoiceCloneConfig().setVolume(50);
    }

    /**
     * 声音复刻demo。
     */
    private void vcsDemo() {
        synthesisVoice();
    }

    private void synthesisVoice() {
        try {

            // 1. 初始化VcsClient
            // 定义authInfo，根据ak，sk，region，projectId
            AuthInfo authInfo = new AuthInfo(ak, sk, region, projectId);
            // 设置config，主要与超时有关
            SisConfig config = getConfig();
            // 根据authInfo和config，构造VcsClient
            VcsClient vcsClient = new VcsClient(authInfo, config);

            // 2. 配置请求
            VcsCloneRequest request = new VcsCloneRequest(voiceName, text);
            setParameters(request);
            request.setSaved(true);  // 是否对合成结果进行保存
            request.setSavePath(audioPath); // 保存路径

            // 3. 发送请求，获取响应。具体结果可通过response.getXX获取。
            VoiceCloneResponse response = vcsClient.synthesisVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        } catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + " error_msg:" + e.getErrorMsg());
        }
    }
}
