package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisConstant;
import com.huawei.sis.bean.request.FlashLasrRequest;
import com.huawei.sis.bean.response.FlashLasrResponse;
import com.huawei.sis.client.FlashLasrClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;

/**
 * 录音文件极速版Demo
 *
 * Copyright 2021 Huawei Technologies Co.,Ltd.
 */
public class FlashLasrDemo {
  // 认证用的ak和sk硬编码到代码中或者明文存储都有很大的安全风险，建议在配置文件或者环境变量中密文存放，使用时解密，确保安全；
  // 本示例以ak和sk保存在环境变量中来实现身份验证为例，运行本示例前请先在本地环境中设置环境变量HUAWEICLOUD_SDK_AK和HUAWEICLOUD_SDK_SK。
  private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
  private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
  private String region = "";    // 区域，如cn-north-1、cn-north-4
  private String projectId = ""; // 项目id，在我的凭证查看。参考https://support.huaweicloud.com/api-sis/sis_03_0008.html

  private String obsBucketName = "";      // obs桶名
  private String obsObjectKey = "";       // obs对象的key
  private String audioFormat = "";        // 文件格式，如wav等， 支持格式详见api文档
  private String property = "";           // 属性字符串，language_sampleRate_domain, 如chinese_8k_common, 详见api文档


  /**
   * 设置录音文件识别极速版参数
   *
   * @param request 录音文件极速版请求
   */
  private void setShortParameter(FlashLasrRequest request) {
    // 以下参数必选
    // 设置桶名，必选
    request.setObsBucketName(obsBucketName);
    // 设置桶内对象名，必选
    request.setObsObjectKey(obsObjectKey);
    // 设置格式，必选
    request.setAudioFormat(audioFormat);
    // 设置属性，必选
    request.setProperty(property);

    // 以下参数可选
    // 设置是否添加标点，默认是no
    request.setAddPunc("yes");
    // 设置热词id，详见api文档，若热词id不存在，则会报错
//     request.setVocabularyId("");
    // 设置是否将音频中数字转写为阿拉伯数字，yes or no，默认yes
    request.setDigitNorm("no");
    // 设置是否需要word_info，yes or no, 默认no
    request.setNeedWordInfo("no");
    // 设置是否只识别收个声道的音频数据，默认no
    request.setFirstChannelOnly("no");
  }

  /**
   * 定义config，所有参数可选，设置超时时间等。
   *
   * @return SisConfig
   */
  private SisConfig getConfig() {
    SisConfig config = new SisConfig();
    // 设置连接超时，默认10000ms
    config.setConnectionTimeout(SisConstant.DEFAULT_CONNECTION_TIMEOUT);
    // 设置读取超时，默认10000ms
    config.setReadTimeout(SisConstant.DEFAULT_READ_TIMEOUT);
    // 设置代理, 一定要确保代理可用才启动此设置。 代理初始化也可用不加密的代理，new ProxyHostInfo(host, port);
    // ProxyHostInfo proxy = new ProxyHostInfo(host, port, username, password);
    // config.setProxy(proxy);
    return config;
  }

  /**
   * 录音文件极速版demo。
   */
  private void flashLasrDemo() {
    try {

      // 1. 初始化FlashLasrClient
      // 定义authInfo，根据ak，sk，region，projectId
      AuthInfo authInfo = new AuthInfo(ak, sk, region, projectId);
      // 设置config，主要与超时有关
      SisConfig config = getConfig();
      // 根据authInfo和config，构造FlashLasrClient
      FlashLasrClient flashLasrClient = new FlashLasrClient(authInfo, config);

      // 2. 配置请求
      FlashLasrRequest request = new FlashLasrRequest();
      setShortParameter(request);

      // 3. 发送请求，获取响应。具体结果可通过response.getXX获取。
      FlashLasrResponse response = flashLasrClient.getFlashLasrResponse(request);
      System.out.println(JsonUtils.obj2Str(response, true));
    } catch (SisException e) {
      e.printStackTrace();
      System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
    }
  }


  public static void main(String[] args) {
    FlashLasrDemo demo = new FlashLasrDemo();
    demo.flashLasrDemo();
  }
}
