/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.util;

import com.cloud.sdk.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.sis.bean.response.ErrorResp;
import com.huawei.sis.exception.SisException;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T str2Obj(String jsonStr, Class<T> clazz) throws SisException {
        if (jsonStr == null || clazz == null) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? jsonStr : OBJECT_MAPPER.readValue(jsonStr, clazz));
        }
        catch (IOException e) {
            log.error("parse string {} to object error, exception is {}", (Object)jsonStr, (Object)e.getMessage());
            throw new SisException("parse string " + jsonStr + " to object error", e);
        }
    }

    public static <T> String obj2Str(T obj) throws SisException {
        return JsonUtils.obj2Str(obj, false);
    }

    public static <T> String obj2Str(T obj, boolean pretty) throws SisException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            if (pretty) {
                return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("parse object to string error", (Throwable)e);
            throw new SisException("parse object to string error", e);
        }
    }

    public static String node2Str(JsonNode jsonNode) throws SisException {
        try {
            String result = OBJECT_MAPPER.writeValueAsString((Object)jsonNode);
            return result;
        }
        catch (JsonProcessingException e) {
            log.error("convert node to json string failed", (Throwable)e);
            throw new SisException("convert node to json string failed", e);
        }
    }

    public static void checkError(String jsonStr) throws SisException {
        if (StringUtils.isNullOrEmpty((String)jsonStr)) {
            log.warn("json is empty");
            return;
        }
        if (jsonStr.contains("error_code") || jsonStr.contains("error_msg")) {
            ErrorResp errorResp = JsonUtils.str2Obj(jsonStr, ErrorResp.class);
            log.error(jsonStr);
            throw new SisException(errorResp.getErrorCode(), errorResp.getErrorMsg());
        }
    }
}

