/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.util;

import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.exception.SisException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IOUtils.class);

    public static void writeTtsFile(String base64Data, String fileName) throws SisException {
        boolean result;
        File parentFile;
        File f = new File(fileName);
        String parentPath = f.getParent();
        if (!StringUtils.isNullOrEmpty((String)parentPath) && !(parentFile = new File(parentPath)).exists() && (result = parentFile.mkdirs())) {
            log.info("Success to create {}", (Object)parentPath);
        }
        byte[] fileBytes = Base64.getDecoder().decode(base64Data);
        IOUtils.writeBytesToFile(fileName, fileBytes);
        log.info("Success to save {}", (Object)fileName);
    }

    public static void writeBytesToFile(String fileName, byte[] data) throws SisException {
        boolean result;
        File fParent;
        File f = new File(fileName);
        String parentPath = f.getParent();
        if (!(StringUtils.isNullOrEmpty((String)parentPath) || (fParent = new File(parentPath)).exists() || (result = fParent.mkdirs()))) {
            log.error("Fail to create {}", (Object)fileName);
        }
        try (FileChannel fc = new FileOutputStream(fileName).getChannel();){
            if (StringUtils.isNullOrEmpty((String)fileName)) {
                return;
            }
            ByteBuffer bb = ByteBuffer.wrap(data);
            fc.write(bb);
        }
        catch (IOException e) {
            log.error("IO exception occurs in write byte array, file path is {}, exception is {}", (Object)fileName, (Object)e.getMessage());
            throw new SisException("IO exception occurs in write byte array, file path is " + fileName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileData(String fileName) throws SisException {
        File fileSrc = new File(fileName);
        if (!fileSrc.exists()) {
            log.error("{} don't exist", (Object)fileName);
            throw new IllegalAccessError(fileName + " don't exist");
        }
        int size = (int)fileSrc.length();
        try (FileInputStream rd = new FileInputStream(fileSrc);){
            byte[] data = new byte[size];
            int result = rd.read(data);
            if (result == -1) {
                log.warn("file {} is empty", (Object)fileName);
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            log.error("Fail to read file: {}, exception is {} ", (Object)fileName, (Object)e.getMessage());
            throw new SisException("Fail to read file:  " + fileName, e);
        }
    }

    public static String getEncodeDataByPath(String path) throws SisException {
        byte[] fileData = IOUtils.getFileData(path);
        String fileBase64Str = Base64.getEncoder().encodeToString(fileData);
        return fileBase64Str;
    }
}

