/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.service;

import com.huawei.sis.bean.SisEnum;
import com.huawei.sis.bean.VcsListener;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.bean.response.VcsDataResponse;
import com.huawei.sis.bean.response.VcsTextResponse;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsService
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(VcsService.class);
    private SisEnum.WebsocketStatus status;
    private CountDownLatch connectLatch;
    private CountDownLatch sendLatch;
    private CountDownLatch sendEndLatch;
    private VcsListener vcsListener;

    public VcsService(VcsListener vcsListener) {
        this.vcsListener = vcsListener;
        this.status = SisEnum.WebsocketStatus.STATE_INIT;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.status = SisEnum.WebsocketStatus.STATE_CONNECTED;
        if (this.connectLatch != null) {
            this.connectLatch.countDown();
        }
        this.vcsListener.onTranscriptionConnect();
        log.debug("websocket connected");
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        if (webSocket != null) {
            webSocket.close(1000, "normal");
        }
    }

    public void onMessage(WebSocket websocket, String text) {
        try {
            VcsTextResponse vcsTextResponse = JsonUtils.str2Obj(text, VcsTextResponse.class);
            switch (vcsTextResponse.getRespType()) {
                case "START": {
                    this.status = SisEnum.WebsocketStatus.STATE_START;
                    if (this.sendLatch != null) {
                        this.sendLatch.countDown();
                    }
                    StateResponse stateResponse = new StateResponse("start", vcsTextResponse.getTraceId(), "start to synthesis text");
                    this.vcsListener.onTranscriptionBegin(stateResponse);
                    break;
                }
                case "END": {
                    this.status = SisEnum.WebsocketStatus.STATE_END;
                    if (this.sendEndLatch != null) {
                        this.sendEndLatch.countDown();
                    }
                    StateResponse stateResponse = new StateResponse("end", vcsTextResponse.getTraceId(), vcsTextResponse.getReason());
                    this.vcsListener.onSTranscriptionEnd(stateResponse);
                    break;
                }
                case "ERROR": 
                case "FATAL_ERROR": {
                    this.status = SisEnum.WebsocketStatus.STATE_ERROR;
                    this.clearLatch();
                    log.error("receive error resp from server {}", (Object)text);
                    StateResponse stateResponse = new StateResponse("error", vcsTextResponse.getTraceId(), text);
                    this.vcsListener.onTranscriptionFail(stateResponse);
                    break;
                }
                default: {
                    log.warn("traceId {}, respType {}, is invalid", (Object)vcsTextResponse.getTraceId(), (Object)vcsTextResponse.getRespType());
                    break;
                }
            }
        }
        catch (SisException e) {
            log.error("websocket response {} can't be prased, error_code is {}, error_msg is {}", new Object[]{text, e.getErrorCode(), e.getErrorMsg()});
        }
    }

    public void onMessage(WebSocket webSocket, ByteString byteString) {
        byte[] data = byteString.toByteArray();
        VcsDataResponse vcsDataResponse = new VcsDataResponse();
        vcsDataResponse.setData(data);
        this.vcsListener.onTranscriptionResponse(vcsDataResponse);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.status = SisEnum.WebsocketStatus.STATE_CLOSE;
        this.clearLatch();
        this.vcsListener.onTranscriptionClose();
        log.debug("websocket closed, {}", (Object)reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.status = SisEnum.WebsocketStatus.STATE_ERROR;
        this.clearLatch();
        log.error("websocket connect failed", t);
        StateResponse stateResponse = new StateResponse(this.status.getStatus(), "", t.getMessage());
        this.vcsListener.onTranscriptionFail(stateResponse);
    }

    private void clearLatch() {
        if (this.connectLatch != null) {
            this.connectLatch.countDown();
        }
        if (this.sendLatch != null) {
            this.sendLatch.countDown();
        }
    }

    @Generated
    public SisEnum.WebsocketStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(SisEnum.WebsocketStatus status) {
        this.status = status;
    }

    @Generated
    public void setConnectLatch(CountDownLatch connectLatch) {
        this.connectLatch = connectLatch;
    }

    @Generated
    public void setSendLatch(CountDownLatch sendLatch) {
        this.sendLatch = sendLatch;
    }

    @Generated
    public void setSendEndLatch(CountDownLatch sendEndLatch) {
        this.sendEndLatch = sendEndLatch;
    }
}

