/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.service;

import com.cloud.sdk.http.HttpMethodName;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.AuthUtils;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;
import com.huawei.sis.util.ResponseProcessUtils;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpService {
    private AuthInfo authInfo = null;
    private OkHttpClient httpClient = null;

    public HttpService(AuthInfo authInfo, SisConfig config) {
        this.authInfo = authInfo;
        this.httpClient = OKHttpClientUtils.getOkHttpClient(config);
    }

    public HttpService(AuthInfo authInfo) {
        this(authInfo, new SisConfig());
    }

    public String getHttpApiResponse(String url, Map<String, String> headers, String params, HttpMethodName method) throws SisException {
        Request signedRequest = AuthUtils.getSignedRequest(this.authInfo, url, headers, params, method);
        Response response = OKHttpClientUtils.getHttpResponse(this.httpClient, signedRequest);
        String jsonResult = ResponseProcessUtils.convertResponseToStr(response);
        ResponseProcessUtils.closeResponse(response);
        JsonUtils.checkError(jsonResult);
        return jsonResult;
    }
}

