/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.RegisterVoiceRequest;
import com.huawei.sis.bean.response.RegisterVoiceResponse;
import com.huawei.sis.bean.response.VoicesResponse;
import com.huawei.sis.client.VcsClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsRegisterAndRequest {
    private static final Logger log = LoggerFactory.getLogger(VcsRegisterAndRequest.class);
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String serviceEndPoint = "";
    private String path = "";

    public static void main(String[] args) {
        VcsRegisterAndRequest vcsRegisterAndRequest = new VcsRegisterAndRequest();
        vcsRegisterAndRequest.RegisterAndRequest();
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void RegisterAndRequest() {
        this.registerVoice();
        this.listVoice();
    }

    private void registerVoice() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            VcsClient vcsClient = new VcsClient(authInfo, config);
            String data = IOUtils.getEncodeDataByPath(this.path);
            String voiceName = "";
            String language = "chinese";
            RegisterVoiceRequest request = new RegisterVoiceRequest(voiceName, data, language);
            RegisterVoiceResponse response = vcsClient.registerVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + " error_msg:" + e.getErrorMsg());
        }
    }

    private VoicesResponse listVoice() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId, this.serviceEndPoint);
            SisConfig config = this.getConfig();
            VcsClient vcsClient = new VcsClient(authInfo, config);
            VoicesResponse response = vcsClient.query(10, 0);
            log.info(JsonUtils.obj2Str(response, true));
            return response;
        }
        catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + " error_msg:" + e.getErrorMsg());
            return null;
        }
    }
}

