/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.VcsCloneRequest;
import com.huawei.sis.bean.response.VoiceCloneResponse;
import com.huawei.sis.client.VcsClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsDemo {
    private static final Logger log = LoggerFactory.getLogger(VcsDemo.class);
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String serviceEndPoint = "";
    private String voiceName = "";
    private String text = "";
    private String audioPath = "";

    public static void main(String[] args) {
        VcsDemo demo = new VcsDemo();
        demo.vcsDemo();
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void setParameters(VcsCloneRequest request) {
        request.getVoiceCloneConfig().setAudioFormat("wav");
        request.getVoiceCloneConfig().setSampleRate("16000");
        request.getVoiceCloneConfig().setVoiceName(this.voiceName);
        request.getVoiceCloneConfig().setSpeed(0);
        request.getVoiceCloneConfig().setPitch(0);
        request.getVoiceCloneConfig().setVolume(50);
    }

    private void vcsDemo() {
        this.synthesisVoice();
    }

    private void synthesisVoice() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            VcsClient vcsClient = new VcsClient(authInfo, config);
            VcsCloneRequest request = new VcsCloneRequest(this.voiceName, this.text);
            this.setParameters(request);
            request.setSaved(true);
            request.setSavePath(this.audioPath);
            VoiceCloneResponse response = vcsClient.synthesisVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + " error_msg:" + e.getErrorMsg());
        }
    }
}

