/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.RasrListener;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.SasrWebsocketRequest;
import com.huawei.sis.bean.response.RasrResponse;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.client.SasrWebsocketClient;
import com.huawei.sis.util.JsonUtils;

public class SasrWebsocketDemo {
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String path = "";
    private String audioFormat = "";
    private String property = "";

    private void setParameters(SasrWebsocketRequest request) {
        request.setAddPunc("yes");
        request.setIntermediateResult("no");
        request.setDigitNorm("no");
        request.setNeedWordInfo("no");
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private RasrListener getRasrListener() {
        RasrListener rasrListener = new RasrListener(){

            @Override
            public void onTranscriptionConnect() {
                System.out.println("sasr websocket connected");
            }

            @Override
            public void onTranscriptionClose() {
                System.out.println("sasr websocket closed");
            }

            @Override
            public void onTranscriptionResponse(RasrResponse response) {
                SasrWebsocketDemo.this.printResponse(response);
            }

            @Override
            public void onTranscriptionBegin(StateResponse response) {
                SasrWebsocketDemo.this.printResponse(response);
            }

            @Override
            public void onSTranscriptionEnd(StateResponse response) {
                SasrWebsocketDemo.this.printResponse(response);
            }

            @Override
            public void onTranscriptionFail(StateResponse response) {
                SasrWebsocketDemo.this.printResponse(response);
            }

            @Override
            public void onEvent(String event) {
                log.info("receive event {}", (Object)event);
            }
        };
        return rasrListener;
    }

    private void printResponse(Object response) {
        try {
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        RasrListener listener = this.getRasrListener();
        AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
        try (SasrWebsocketClient sasrWebsocketClient = new SasrWebsocketClient(authInfo, listener, this.getConfig());){
            SasrWebsocketRequest request = new SasrWebsocketRequest(this.audioFormat, this.property);
            this.setParameters(request);
            sasrWebsocketClient.sasrConnect(request);
            sasrWebsocketClient.sendStart();
            sasrWebsocketClient.sendAudio(this.path);
            sasrWebsocketClient.sendEnd();
        }
    }

    public static void main(String[] args) {
        SasrWebsocketDemo sasrWebsocketDemo = new SasrWebsocketDemo();
        sasrWebsocketDemo.process();
    }
}

