/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.VcsListener;
import com.huawei.sis.bean.request.VcsRequest;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.bean.response.VcsDataResponse;
import com.huawei.sis.client.RvcsClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RvcsDemo {
    private static final Logger log = LoggerFactory.getLogger(RvcsDemo.class);
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String serviceEndPoint = "";
    private String audioPath = "";
    private String textPath = "";
    private String voiceName = "";

    public static void main(String[] args) {
        RvcsDemo rvcsDemo = new RvcsDemo();
        rvcsDemo.process();
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void setParameters(VcsRequest request) {
        request.setAudioFormat("pcm");
        request.setSampleRate("16000");
        request.setVoiceName(this.voiceName);
        request.setSpeed(0);
        request.setPitch(0);
        request.setVolume(50);
        request.setTextPieces("MULTI");
    }

    private void process() {
        try {
            MyVcsListener vcsListener = new MyVcsListener(this.audioPath);
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            final RvcsClient rvcsClient = new RvcsClient(authInfo, vcsListener, this.getConfig());
            vcsListener.onCallback(new MyVcsListener.VcsListenerCallback(){

                @Override
                public void onEnd() {
                    super.onEnd();
                    rvcsClient.close();
                }

                @Override
                public void onFail() {
                    super.onFail();
                    rvcsClient.close();
                }
            });
            VcsRequest vcsRequest = new VcsRequest();
            this.setParameters(vcsRequest);
            rvcsClient.connect(vcsRequest);
            if ("ONLY".equals(vcsRequest.getTextPieces())) {
                vcsRequest.setText("\u6b22\u8fce\u4f7f\u7528\u534e\u4e3a\u4e91\u8bed\u97f3\u4ea4\u4e92\u670d\u52a1\u3002");
                rvcsClient.sendStart();
            } else {
                rvcsClient.sendStart();
                rvcsClient.sendMsg("\u4f60\u597d");
                rvcsClient.sendMsg("\u6b22\u8fce\u4f7f\u7528\u534e\u4e3a\u4e91\u8bed\u97f3\u4ea4\u4e92\u670d\u52a1\u3002");
                rvcsClient.sendEnd();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printResponse(Object response) {
        try {
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            e.printStackTrace();
        }
    }

    private static class MyVcsListener
    implements VcsListener {
        private String path;
        private FileOutputStream fos = null;
        private VcsListenerCallback vcsListenerCallback = new VcsListenerCallback();

        public MyVcsListener() {
        }

        public MyVcsListener(String path) {
            this.path = path;
        }

        @Override
        public void onTranscriptionClose() {
            System.out.println("websocket closed");
        }

        @Override
        public void onTranscriptionConnect() {
            System.out.println("websocket connected");
        }

        @Override
        public void onTranscriptionResponse(VcsDataResponse response) {
            System.out.println("receive binary data " + response.getData().length);
            if (this.fos == null) {
                return;
            }
            try {
                this.fos.write(response.getData());
                this.fos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTranscriptionBegin(StateResponse response) {
            RvcsDemo.printResponse(response);
            try {
                if (StringUtils.isNullOrEmpty((String)this.path)) {
                    return;
                }
                File f = new File(this.path);
                this.fos = new FileOutputStream(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onSTranscriptionEnd(StateResponse response) {
            this.vcsListenerCallback.onEnd();
            RvcsDemo.printResponse(response);
            this.close();
        }

        @Override
        public void onTranscriptionFail(StateResponse response) {
            this.vcsListenerCallback.onFail();
            RvcsDemo.printResponse(response);
            this.close();
        }

        private void close() {
            if (this.fos == null) {
                return;
            }
            try {
                this.fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void onCallback(VcsListenerCallback callback) {
            if (callback == null) {
                return;
            }
            this.vcsListenerCallback = callback;
        }

        public static class VcsListenerCallback {
            public void onEnd() {
            }

            public void onFail() {
            }
        }
    }
}

