/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.RttsListener;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.RttsRequest;
import com.huawei.sis.bean.response.RttsDataResponse;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.client.RttsClient;
import com.huawei.sis.util.JsonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class RttsDemo {
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String text = "";
    private String path = "";

    public static void main(String[] args) {
        RttsDemo rttsDemo = new RttsDemo();
        rttsDemo.process();
    }

    private RttsRequest getRttsRequest() {
        RttsRequest request = new RttsRequest();
        request.setCommand("START");
        request.setText(this.text);
        RttsRequest.Config config = new RttsRequest.Config();
        config.setPorperty("chinese_xiaoyan_common");
        config.setAudioFormat("pcm");
        config.setSampleRate("8000");
        config.setVolume(50);
        config.setPitch(0);
        config.setSpeed(0);
        request.setConfig(config);
        return request;
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        config.setWebsocketWaitTimeout(20000);
        return config;
    }

    private void printResponse(Object response) {
        try {
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process() {
        MyRttsListener rttsListener = new MyRttsListener(this.path);
        AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
        RttsClient rttsClient = new RttsClient(authInfo, (RttsListener)rttsListener, this.getConfig());
        RttsRequest request = this.getRttsRequest();
        try {
            rttsClient.synthesis(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class MyRttsListener
    implements RttsListener {
        private String path;
        private FileOutputStream fos = null;

        public MyRttsListener() {
        }

        public MyRttsListener(String path) {
            this.path = path;
        }

        @Override
        public void onTranscriptionResponse(RttsDataResponse rttsDataResponse) {
            System.out.println("receive binary data " + rttsDataResponse.getData().length);
            if (this.fos == null) {
                return;
            }
            try {
                this.fos.write(rttsDataResponse.getData());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onTranscriptionBegin(StateResponse response) {
            RttsDemo.this.printResponse(response);
            try {
                if (StringUtils.isNullOrEmpty((String)this.path)) {
                    return;
                }
                File f = new File(this.path);
                this.fos = new FileOutputStream(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onSTranscriptionEnd(StateResponse response) {
            RttsDemo.this.printResponse(response);
            this.close();
        }

        @Override
        public void onTranscriptionFail(StateResponse response) {
            RttsDemo.this.printResponse(response);
            this.close();
        }

        private void close() {
            if (this.fos == null) {
                return;
            }
            try {
                this.fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

