/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.HotWordRequest;
import com.huawei.sis.bean.response.HotWordResponse;
import com.huawei.sis.bean.response.HotWordsResponse;
import com.huawei.sis.client.HotWordClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;

public class HotWordDemo {
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String name = "test";
    private String vocabularyId = "";
    private List<String> hotWordList = new ArrayList<String>();

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void hotWordDemo() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            HotWordClient hotWordClient = new HotWordClient(authInfo, config);
            this.hotWordList.add("\u6d4b\u8bd5");
            HotWordRequest hotWordRequest = new HotWordRequest(this.name, this.hotWordList);
            hotWordRequest.setDescription("test");
            hotWordRequest.setLanguage("chinese_mandarin");
            this.vocabularyId = hotWordClient.create(hotWordRequest);
            System.out.println("\u6210\u529f\u521b\u5efa\u70ed\u8bcd\u8868\uff0c\u70ed\u8bcd\u8868id\u4e3a" + this.vocabularyId);
            this.hotWordList.add("\u534e\u4e3a");
            HotWordRequest updateRequest = new HotWordRequest(this.name, this.hotWordList);
            String updateVocabularyId = hotWordClient.update(updateRequest, this.vocabularyId);
            System.out.println("\u6210\u529f\u66f4\u65b0\u70ed\u8bcd\u8868\uff0c\u70ed\u8bcd\u8868id\u4e3a" + updateVocabularyId);
            HotWordsResponse hotWordListResponse = hotWordClient.query();
            System.out.println(JsonUtils.obj2Str(hotWordListResponse, true));
            HotWordResponse hotWordResponse = hotWordClient.query(this.vocabularyId);
            System.out.println(JsonUtils.obj2Str(hotWordResponse, true));
            hotWordClient.delete(this.vocabularyId);
        }
        catch (SisException e) {
            e.printStackTrace();
            System.out.println("error_code:" + e.getErrorCode() + "\terror_msg:" + e.getErrorMsg());
        }
    }

    public static void main(String[] args) {
        HotWordDemo hotWordDemo = new HotWordDemo();
        hotWordDemo.hotWordDemo();
    }
}

