/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.FlashLasrRequest;
import com.huawei.sis.bean.response.FlashLasrResponse;
import com.huawei.sis.client.FlashLasrClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;

public class FlashLasrDemo {
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String obsBucketName = "";
    private String obsObjectKey = "";
    private String audioFormat = "";
    private String property = "";

    private void setShortParameter(FlashLasrRequest request) {
        request.setObsBucketName(this.obsBucketName);
        request.setObsObjectKey(this.obsObjectKey);
        request.setAudioFormat(this.audioFormat);
        request.setProperty(this.property);
        request.setAddPunc("yes");
        request.setDigitNorm("no");
        request.setNeedWordInfo("no");
        request.setFirstChannelOnly("no");
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void flashLasrDemo() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            FlashLasrClient flashLasrClient = new FlashLasrClient(authInfo, config);
            FlashLasrRequest request = new FlashLasrRequest();
            this.setShortParameter(request);
            FlashLasrResponse response = flashLasrClient.getFlashLasrResponse(request);
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            e.printStackTrace();
            System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    public static void main(String[] args) {
        FlashLasrDemo demo = new FlashLasrDemo();
        demo.flashLasrDemo();
    }
}

