/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.cloud.sdk.http.HttpMethodName;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.TtsCustomRequest;
import com.huawei.sis.bean.response.TtsCustomResponse;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.HttpService;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;
import java.util.Map;

public class TtsCustomizationClient {
    private AuthInfo authInfo = null;
    private HttpService httpService = null;
    private String ttsUrl;

    public TtsCustomizationClient(AuthInfo authinfo, SisConfig config) {
        this.authInfo = authinfo;
        this.httpService = new HttpService(this.authInfo, config);
        this.ttsUrl = authinfo.getServiceEndPoint() + "/v1/" + authinfo.getProjectId() + "/tts";
    }

    public TtsCustomizationClient(AuthInfo authInfo) {
        this(authInfo, new SisConfig());
    }

    public TtsCustomResponse getTtsResponse(TtsCustomRequest request) throws SisException {
        return this.getTtsResponse(null, request);
    }

    public TtsCustomResponse getTtsResponse(Map<String, String> headers, TtsCustomRequest request) throws SisException {
        String params = request.constructParams();
        if (headers == null) {
            headers = OKHttpClientUtils.getJsonHeaders();
        }
        String result = this.httpService.getHttpApiResponse(this.ttsUrl, headers, params, HttpMethodName.POST);
        TtsCustomResponse response = JsonUtils.str2Obj(result, TtsCustomResponse.class);
        if (request.isSaved()) {
            IOUtils.writeTtsFile(response.getResult().getData(), request.getSavePath());
            response.setSaved(request.isSaved());
            response.setSavePath(request.getSavePath());
        }
        return response;
    }
}

