/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisEnum;
import com.huawei.sis.bean.VcsListener;
import com.huawei.sis.bean.request.VcsRequest;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.VcsService;
import com.huawei.sis.service.WebSocketService;
import com.huawei.sis.util.JsonUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RvcsClient {
    private static final Logger log = LoggerFactory.getLogger(RvcsClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int WAIT_SLEEP_TIME = 20;
    private static final int RETRY_COUNT = 5;
    private WebSocketService ws = null;
    private String serviceEndpoint;
    private SisConfig config;
    private VcsService vcsService;
    private String api;
    private CountDownLatch connectLatch;
    private CountDownLatch sendLatch;
    private VcsRequest request;
    private int sendMsgCount;

    public RvcsClient(AuthInfo authInfo, VcsListener vcsListener, SisConfig config) {
        this.serviceEndpoint = authInfo.getServiceEndPoint();
        this.vcsService = new VcsService(vcsListener);
        this.ws = new WebSocketService(authInfo, config, (WebSocketListener)this.vcsService);
        this.config = config;
        this.api = "/v1/" + authInfo.getProjectId() + "/vcs/voices/clone";
    }

    public void connect(VcsRequest vcsRequest) throws SisException {
        this.connect(null, vcsRequest);
    }

    public void connect(Map<String, String> headers, VcsRequest vcsRequest) throws SisException {
        this.request = vcsRequest;
        String url = this.serviceEndpoint + this.api;
        if (this.checkConnect()) {
            this.connectLatch = new CountDownLatch(1);
            this.vcsService.setConnectLatch(this.connectLatch);
            this.vcsService.setStatus(SisEnum.WebsocketStatus.STATE_CONNECT_WAITING);
            this.ws.connectWebsocket(url, headers);
            try {
                if (!this.connectLatch.await(20L, TimeUnit.SECONDS)) {
                    log.error("connect to {} failed", (Object)url);
                    throw new SisException("connect to server failed in 20 seconds");
                }
            }
            catch (InterruptedException e) {
                log.error("connect to {} occurs interrupt exception {}", (Object)url, (Object)e.getMessage());
                throw new SisException("connect vcs occurs interrupt exception");
            }
        }
    }

    public void sendStart() throws SisException {
        if (this.vcsService.getStatus() != SisEnum.WebsocketStatus.STATE_CONNECTED && this.vcsService.getStatus() != SisEnum.WebsocketStatus.STATE_END) {
            log.error("status {} can't send start", (Object)this.vcsService.getStatus().getStatus());
            throw new SisException("status " + this.vcsService.getStatus().getStatus() + " can't send start command");
        }
        this.vcsService.setStatus(SisEnum.WebsocketStatus.STATE_START_WAITING);
        this.sendLatch = new CountDownLatch(1);
        this.vcsService.setSendLatch(this.sendLatch);
        this.ws.sendStrData(this.request.constructParams());
        try {
            if (!this.sendLatch.await(this.config.getWebsocketWaitTimeout(), TimeUnit.MILLISECONDS)) {
                log.error("status {} wait end response timeout {}", (Object)this.vcsService.getStatus().getStatus(), (Object)this.config.getWebsocketWaitTimeout());
                throw new SisException("wait end response occurs interrupted exception");
            }
        }
        catch (InterruptedException e) {
            log.error("wait end response occurs interrupted exception", (Throwable)e);
            throw new SisException("wait end response occurs interrupted exception");
        }
    }

    public void sendMsg(String text) throws SisException {
        if (this.vcsService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
            log.warn("status {} can't send msg command, only support status start", (Object)this.vcsService.getStatus().getStatus());
            return;
        }
        if (this.vcsService.getStatus() != SisEnum.WebsocketStatus.STATE_START) {
            log.error("status {} can't send msg command, only support status start", (Object)this.vcsService.getStatus().getStatus());
            throw new SisException("status " + this.vcsService.getStatus().getStatus() + " can't send msg command");
        }
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("command", "MSG");
        rootNode.put("text", text);
        this.ws.sendStrData(JsonUtils.node2Str((JsonNode)rootNode));
        log.info("send msg chunk: {}", (Object)(++this.sendMsgCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgBatch(String path) throws SisException {
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.sendMsg(line);
            }
        }
        catch (FileNotFoundException e) {
            log.error("file not found: {}", (Object)path);
            throw new SisException("file not found: {}", path);
        }
        catch (IOException e) {
            throw new SisException("read file occurs error: {}", e);
        }
    }

    public void sendEnd() throws SisException {
        if (this.vcsService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
            log.warn("status {} can't send end command, only support status start", (Object)this.vcsService.getStatus().getStatus());
            return;
        }
        if (this.vcsService.getStatus() != SisEnum.WebsocketStatus.STATE_START) {
            log.error("status {} can't send end command, only support status start", (Object)this.vcsService.getStatus().getStatus());
            throw new SisException("status " + this.vcsService.getStatus().getStatus() + " can't send end command");
        }
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("command", "END");
        this.vcsService.setStatus(SisEnum.WebsocketStatus.STATE_END_WAITING);
        CountDownLatch endLatch = new CountDownLatch(1);
        this.vcsService.setSendEndLatch(endLatch);
        this.ws.sendStrData(JsonUtils.node2Str((JsonNode)rootNode));
    }

    public void close() {
        this.ws.closeWebsocket();
    }

    private boolean checkConnect() {
        if (this.vcsService.getStatus() != SisEnum.WebsocketStatus.STATE_INIT && this.vcsService.getStatus() != SisEnum.WebsocketStatus.STATE_CLOSE) {
            if (this.vcsService.getStatus() == SisEnum.WebsocketStatus.STATE_ERROR || this.vcsService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
                this.close();
            }
            return false;
        }
        return true;
    }
}

