/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.RttsListener;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisEnum;
import com.huawei.sis.bean.UserInfo;
import com.huawei.sis.bean.request.RttsRequest;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.RttsService;
import com.huawei.sis.service.WebSocketService;
import com.huawei.sis.util.JsonUtils;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RttsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RttsClient.class);
    private static final int WAIT_SLEEP_TIME = 20;
    private static final int RETRY_COUNT = 5;
    private WebSocketService ws = null;
    private String serviceEndpoint;
    private SisConfig config;
    private RttsService rttsService;
    private String api;
    private CountDownLatch connectLatch;
    private CountDownLatch sendLatch;

    public RttsClient(AuthInfo authInfo, RttsListener rttsListener) {
        this(authInfo, rttsListener, new SisConfig());
    }

    @Deprecated
    public RttsClient(UserInfo userInfo, RttsListener rttsListener) {
        this(userInfo, rttsListener, new SisConfig());
    }

    @Deprecated
    public RttsClient(UserInfo userInfo, RttsListener rttsListener, SisConfig sisConfig) {
        this.serviceEndpoint = userInfo.getServiceEndpoint();
        this.rttsService = new RttsService(rttsListener);
        this.config = sisConfig;
        this.ws = new WebSocketService(userInfo, sisConfig, (WebSocketListener)this.rttsService);
        this.api = "/v1/" + userInfo.getProjectId() + "/rtts";
    }

    public RttsClient(AuthInfo authInfo, RttsListener rttsListener, SisConfig config) {
        this.serviceEndpoint = authInfo.getServiceEndPoint();
        this.rttsService = new RttsService(rttsListener);
        this.ws = new WebSocketService(authInfo, config, (WebSocketListener)this.rttsService);
        this.config = config;
        this.api = "/v1/" + authInfo.getProjectId() + "/rtts";
    }

    public void synthesis(RttsRequest rttsRequest) throws SisException {
        this.synthesis(null, rttsRequest);
    }

    public void synthesis(Map<String, String> headers, RttsRequest rttsRequest) throws SisException {
        try {
            this.connect(headers);
            this.sendRequest(rttsRequest);
        }
        finally {
            this.close();
        }
    }

    public void sendRequest(RttsRequest rttsRequest) throws SisException {
        String text = JsonUtils.obj2Str(rttsRequest);
        if (this.checkSend()) {
            this.rttsService.setStatus(SisEnum.WebsocketStatus.STATE_END_WAITING);
            this.sendLatch = new CountDownLatch(1);
            this.rttsService.setSendLatch(this.sendLatch);
            this.ws.sendStrData(text);
            try {
                if (!this.sendLatch.await(this.config.getWebsocketWaitTimeout(), TimeUnit.MILLISECONDS)) {
                    log.error("status {} wait end response timeout {}", (Object)this.rttsService.getStatus().getStatus(), (Object)this.config.getWebsocketWaitTimeout());
                    throw new SisException("wait end response occurs interrrupted exception");
                }
            }
            catch (InterruptedException e) {
                log.error("wait end response occurs interrrupted exception", (Throwable)e);
                throw new SisException("wait end response occurs interrrupted exception");
            }
        }
    }

    public void close() {
        this.ws.closeWebsocket();
    }

    private void connect(Map<String, String> headers) throws SisException {
        String url = this.serviceEndpoint + this.api;
        if (this.checkConnect()) {
            this.connectLatch = new CountDownLatch(1);
            this.rttsService.setConnectLatch(this.connectLatch);
            this.rttsService.setStatus(SisEnum.WebsocketStatus.STATE_CONNECT_WAITING);
            this.ws.connectWebsocket(url, headers);
            try {
                if (!this.connectLatch.await(20L, TimeUnit.SECONDS)) {
                    log.error("connect to {} failed", (Object)url);
                    throw new SisException("connect to server failed in 20 seconds");
                }
            }
            catch (InterruptedException e) {
                log.error("connect to {} occurs interrupt exception {}", (Object)url, (Object)e.getMessage());
                throw new SisException("connect rtts occurs interrupt exception");
            }
        }
    }

    private boolean checkConnect() {
        if (this.rttsService.getStatus() == SisEnum.WebsocketStatus.STATE_INIT || this.rttsService.getStatus() == SisEnum.WebsocketStatus.STATE_CLOSE) {
            return true;
        }
        if (this.rttsService.getStatus() == SisEnum.WebsocketStatus.STATE_ERROR || this.rttsService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
            this.close();
            return false;
        }
        return false;
    }

    private boolean checkSend() throws SisException {
        if (this.rttsService.getStatus() == SisEnum.WebsocketStatus.STATE_CONNECTED) {
            return true;
        }
        log.error("status {} can't send start command", (Object)this.rttsService.getStatus().getStatus());
        throw new SisException("status " + this.rttsService.getStatus().getStatus() + " can't send start command");
    }
}

