/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.cloud.sdk.http.HttpMethodName;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.HotWordRequest;
import com.huawei.sis.bean.response.HotWordResponse;
import com.huawei.sis.bean.response.HotWordsResponse;
import com.huawei.sis.bean.response.VocabularyResp;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.HttpService;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;

public class HotWordClient {
    private HttpService service;
    private String baseUrl;

    public HotWordClient(AuthInfo authInfo) {
        this(authInfo, new SisConfig());
    }

    public HotWordClient(AuthInfo authInfo, SisConfig config) {
        this.service = new HttpService(authInfo, config);
        this.baseUrl = authInfo.getServiceEndPoint() + "/v1/" + authInfo.getProjectId() + "/asr/vocabularies";
    }

    public String create(HotWordRequest request) throws SisException {
        String url = this.baseUrl;
        String params = request.constructParams();
        String result = this.service.getHttpApiResponse(url, OKHttpClientUtils.getJsonHeaders(), params, HttpMethodName.POST);
        VocabularyResp vocabularyResp = JsonUtils.str2Obj(result, VocabularyResp.class);
        return vocabularyResp.getVocabularyId();
    }

    public String update(HotWordRequest request, String vocabularyId) throws SisException {
        String url = this.baseUrl + "/" + vocabularyId;
        String params = request.constructParams();
        String result = this.service.getHttpApiResponse(url, OKHttpClientUtils.getJsonHeaders(), params, HttpMethodName.PUT);
        VocabularyResp vocabularyResp = JsonUtils.str2Obj(result, VocabularyResp.class);
        return vocabularyResp.getVocabularyId();
    }

    public HotWordResponse query(String vocabularyId) throws SisException {
        String url = this.baseUrl + "/" + vocabularyId;
        String result = this.service.getHttpApiResponse(url, null, null, HttpMethodName.GET);
        HotWordResponse hotWordResponse = JsonUtils.str2Obj(result, HotWordResponse.class);
        return hotWordResponse;
    }

    public HotWordsResponse query() throws SisException {
        String url = this.baseUrl;
        String result = this.service.getHttpApiResponse(url, null, null, HttpMethodName.GET);
        HotWordsResponse hotWordListResponse = JsonUtils.str2Obj(result, HotWordsResponse.class);
        return hotWordListResponse;
    }

    public void delete(String vocabularyId) throws SisException {
        String url = this.baseUrl + "/" + vocabularyId;
        this.service.getHttpApiResponse(url, null, null, HttpMethodName.DELETE);
    }
}

