/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.cloud.sdk.http.HttpMethodName;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.FlashLasrRequest;
import com.huawei.sis.bean.response.FlashLasrResponse;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.HttpService;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;
import java.util.Map;

public class FlashLasrClient {
    private AuthInfo authInfo = null;
    private HttpService httpService = null;
    private String flashLasrUrl;

    public FlashLasrClient(AuthInfo authinfo, SisConfig config) {
        this.authInfo = authinfo;
        this.httpService = new HttpService(this.authInfo, config);
        this.flashLasrUrl = authinfo.getServiceEndPoint() + "/v1/" + authinfo.getProjectId() + "/asr/flash";
    }

    public FlashLasrClient(AuthInfo authInfo) {
        this(authInfo, new SisConfig());
    }

    public FlashLasrResponse getFlashLasrResponse(Map<String, String> headers, FlashLasrRequest request) throws SisException {
        String queryUrl = this.flashLasrUrl + request.constructParams();
        if (headers == null) {
            headers = OKHttpClientUtils.getJsonHeaders();
        }
        String result = this.httpService.getHttpApiResponse(queryUrl, headers, null, HttpMethodName.POST);
        FlashLasrResponse response = JsonUtils.str2Obj(result, FlashLasrResponse.class);
        return response;
    }

    public FlashLasrResponse getFlashLasrResponse(FlashLasrRequest request) throws SisException {
        return this.getFlashLasrResponse(null, request);
    }
}

