/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.bean.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VcsCloneRequest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="text")
    private String userInputText;
    @JsonProperty(value="config")
    private VoiceCloneConfig voiceCloneConfig;
    private boolean isSaved = false;
    private String savePath = "data/1.wav";

    public VcsCloneRequest(String voiceName, String text) {
        VoiceCloneConfig config = new VoiceCloneConfig();
        config.voiceName = voiceName;
        config.sampleRate = "16000";
        config.audioFormat = "wav";
        config.speed = 0;
        config.pitch = 0;
        config.volume = 50;
        this.userInputText = text;
        this.voiceCloneConfig = config;
    }

    public VcsCloneRequest(String voiceName, String text, String audioFormat, String sampleRate) {
        VoiceCloneConfig config = new VoiceCloneConfig();
        config.voiceName = voiceName;
        config.sampleRate = sampleRate;
        config.audioFormat = audioFormat;
        config.speed = 0;
        config.pitch = 0;
        config.volume = 50;
        this.userInputText = text;
        this.voiceCloneConfig = config;
    }

    public VcsCloneRequest(String voiceName, String text, String audioFormat, String sampleRate, Integer speed, Integer pitch, Integer volume) {
        VoiceCloneConfig config = new VoiceCloneConfig();
        config.voiceName = voiceName;
        config.sampleRate = sampleRate;
        config.audioFormat = audioFormat;
        config.speed = speed;
        config.pitch = pitch;
        config.volume = volume;
        this.userInputText = text;
        this.voiceCloneConfig = config;
    }

    public String constructParams() throws SisException {
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("text", this.userInputText);
        ObjectNode config = OBJECT_MAPPER.createObjectNode();
        config.put("audio_format", this.voiceCloneConfig.audioFormat);
        config.put("sample_rate", this.voiceCloneConfig.sampleRate);
        config.put("voice_name", this.voiceCloneConfig.voiceName);
        config.put("speed", this.voiceCloneConfig.speed);
        config.put("pitch", this.voiceCloneConfig.pitch);
        config.put("volume", this.voiceCloneConfig.volume);
        rootNode.set("config", (JsonNode)config);
        return JsonUtils.node2Str((JsonNode)rootNode);
    }

    @Generated
    public String getUserInputText() {
        return this.userInputText;
    }

    @Generated
    public VoiceCloneConfig getVoiceCloneConfig() {
        return this.voiceCloneConfig;
    }

    @Generated
    public boolean isSaved() {
        return this.isSaved;
    }

    @Generated
    public String getSavePath() {
        return this.savePath;
    }

    @JsonProperty(value="text")
    @Generated
    public void setUserInputText(String userInputText) {
        this.userInputText = userInputText;
    }

    @JsonProperty(value="config")
    @Generated
    public void setVoiceCloneConfig(VoiceCloneConfig voiceCloneConfig) {
        this.voiceCloneConfig = voiceCloneConfig;
    }

    @Generated
    public void setSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    @Generated
    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class VoiceCloneConfig {
        @JsonProperty(value="audio_format")
        private String audioFormat;
        @JsonProperty(value="sample_rate")
        private String sampleRate;
        @JsonProperty(value="voice_name")
        private String voiceName;
        @JsonProperty(value="speed")
        private Integer speed;
        @JsonProperty(value="pitch")
        private Integer pitch;
        @JsonProperty(value="volume")
        private Integer volume;

        @JsonProperty(value="audio_format")
        @Generated
        public void setAudioFormat(String audioFormat) {
            this.audioFormat = audioFormat;
        }

        @JsonProperty(value="sample_rate")
        @Generated
        public void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        @JsonProperty(value="voice_name")
        @Generated
        public void setVoiceName(String voiceName) {
            this.voiceName = voiceName;
        }

        @JsonProperty(value="speed")
        @Generated
        public void setSpeed(Integer speed) {
            this.speed = speed;
        }

        @JsonProperty(value="pitch")
        @Generated
        public void setPitch(Integer pitch) {
            this.pitch = pitch;
        }

        @JsonProperty(value="volume")
        @Generated
        public void setVolume(Integer volume) {
            this.volume = volume;
        }

        @Generated
        public String getAudioFormat() {
            return this.audioFormat;
        }

        @Generated
        public String getSampleRate() {
            return this.sampleRate;
        }

        @Generated
        public String getVoiceName() {
            return this.voiceName;
        }

        @Generated
        public Integer getSpeed() {
            return this.speed;
        }

        @Generated
        public Integer getPitch() {
            return this.pitch;
        }

        @Generated
        public Integer getVolume() {
            return this.volume;
        }

        @Generated
        public String toString() {
            return "VcsCloneRequest.VoiceCloneConfig(audioFormat=" + this.getAudioFormat() + ", sampleRate=" + this.getSampleRate() + ", voiceName=" + this.getVoiceName() + ", speed=" + this.getSpeed() + ", pitch=" + this.getPitch() + ", volume=" + this.getVolume() + ")";
        }
    }
}

