/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.bean.request;

import com.cloud.sdk.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class RasrRequest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int DEFAULT_HEAD_SILENCE_TIME = 10000;
    private static final int DEFAULT_TAIL_SILENCE_TIME = 500;
    private static final int DEFAULT_CONTINUE_SECONDS = 30;
    private static final int DEFAULT_VAD_THRESHOLD = 0;
    private String audioFormat;
    private String property;
    private String addPunc = "no";
    private String intermediateResult = "no";
    private String needWordInfo = "no";
    private int vadHead = 10000;
    private int vadTail = 500;
    private int maxSeconds = 30;
    private String vocabularyId = "";
    private String digitNorm = "yes";
    private int vadThreshold = 0;
    private List<String> userWords = new ArrayList<String>();
    private String needSmooth = "no";

    public RasrRequest(String audioFormat, String property) {
        this.audioFormat = audioFormat;
        this.property = property;
    }

    public String constructParams() throws SisException {
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("command", "START");
        ObjectNode startJson = OBJECT_MAPPER.createObjectNode();
        startJson.put("audio_format", this.audioFormat);
        startJson.put("property", this.property);
        startJson.put("add_punc", this.addPunc);
        startJson.put("vad_head", this.vadHead);
        startJson.put("vad_tail", this.vadTail);
        startJson.put("vad_threshold", this.vadThreshold);
        startJson.put("max_seconds", this.maxSeconds);
        startJson.put("interim_results", this.intermediateResult);
        startJson.put("digit_norm", this.digitNorm);
        startJson.put("need_smooth", this.needSmooth);
        if (!StringUtils.isNullOrEmpty((String)this.vocabularyId)) {
            startJson.put("vocabulary_id", this.vocabularyId);
        }
        if (!this.userWords.isEmpty()) {
            ArrayNode arrayNode = startJson.putArray("user_words");
            for (String userWord : this.userWords) {
                arrayNode.add(userWord);
            }
        }
        startJson.put("need_word_info", this.needWordInfo);
        rootNode.set("config", (JsonNode)startJson);
        return JsonUtils.node2Str((JsonNode)rootNode);
    }

    @Generated
    public String getAudioFormat() {
        return this.audioFormat;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public String getAddPunc() {
        return this.addPunc;
    }

    @Generated
    public String getIntermediateResult() {
        return this.intermediateResult;
    }

    @Generated
    public String getNeedWordInfo() {
        return this.needWordInfo;
    }

    @Generated
    public int getVadHead() {
        return this.vadHead;
    }

    @Generated
    public int getVadTail() {
        return this.vadTail;
    }

    @Generated
    public int getMaxSeconds() {
        return this.maxSeconds;
    }

    @Generated
    public String getVocabularyId() {
        return this.vocabularyId;
    }

    @Generated
    public String getDigitNorm() {
        return this.digitNorm;
    }

    @Generated
    public int getVadThreshold() {
        return this.vadThreshold;
    }

    @Generated
    public List<String> getUserWords() {
        return this.userWords;
    }

    @Generated
    public String getNeedSmooth() {
        return this.needSmooth;
    }

    @Generated
    public void setAddPunc(String addPunc) {
        this.addPunc = addPunc;
    }

    @Generated
    public void setIntermediateResult(String intermediateResult) {
        this.intermediateResult = intermediateResult;
    }

    @Generated
    public void setNeedWordInfo(String needWordInfo) {
        this.needWordInfo = needWordInfo;
    }

    @Generated
    public void setVadHead(int vadHead) {
        this.vadHead = vadHead;
    }

    @Generated
    public void setVadTail(int vadTail) {
        this.vadTail = vadTail;
    }

    @Generated
    public void setMaxSeconds(int maxSeconds) {
        this.maxSeconds = maxSeconds;
    }

    @Generated
    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    @Generated
    public void setDigitNorm(String digitNorm) {
        this.digitNorm = digitNorm;
    }

    @Generated
    public void setVadThreshold(int vadThreshold) {
        this.vadThreshold = vadThreshold;
    }

    @Generated
    public void setUserWords(List<String> userWords) {
        this.userWords = userWords;
    }

    @Generated
    public void setNeedSmooth(String needSmooth) {
        this.needSmooth = needSmooth;
    }
}

