package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisConstant;
import com.huawei.sis.bean.request.RegisterVoiceRequest;
import com.huawei.sis.bean.request.VcsCloneRequest;
import com.huawei.sis.bean.response.RegisterVoiceResponse;
import com.huawei.sis.bean.response.VoiceCloneResponse;
import com.huawei.sis.bean.response.VoicesResponse;
import com.huawei.sis.client.VcsClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.JsonUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 一句话识别Demo
 * <p>
 * Copyright 2021 Huawei Technologies Co.,Ltd.
 */
public class VcsDemo {
    /**
     * todo 请正确填写音频格式和模型属性字符串
     *   1. 音频格式一定要相匹配.
     *      例如wav音频，格式是wav。具体参考api文档。
     * <p>
     * 2. 音频采样率要与属性字符串的采样率要匹配。
     * 例如格式选择pcm16k16bit，属性字符串却选择chinese_8k_common, 则会返回'audio_format' is not match model
     * 例如wav本身是16k采样率，属性选择chinese_8k_common, 同样会返回'audio_format' is not match model
     */
    private static final Logger log = LoggerFactory.getLogger(VcsDemo.class);
    String path = "D:\\test.mp3";

    // 认证用的ak和sk硬编码到代码中或者明文存储都有很大的安全风险，建议在配置文件或者环境变量中密文存放，使用时解密，确保安全；
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");

    private String region = "";    // 区域，如cn-north-1、cn-north-4

    private String projectId = ""; // 项目id，在我的凭证查看。参考https://support.huaweicloud.com/api-sis/sis_03_0008.html

    private String endPoint = "";

    public static void main(String[] args) {
        VcsDemo demo = new VcsDemo();
        demo.vcsDemo();
    }

    /**
     * 定义config，所有参数可选，设置超时时间等。
     *
     * @return SisConfig
     */
    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        // 设置连接超时，默认10000ms
        config.setConnectionTimeout(SisConstant.DEFAULT_CONNECTION_TIMEOUT);
        // 设置读取超时，默认10000ms
        config.setReadTimeout(SisConstant.DEFAULT_READ_TIMEOUT);
        // 设置代理, 一定要确保代理可用才启动此设置。 代理初始化也可用不加密的代理，new ProxyHostInfo(host, port);
        return config;
    }

    /**
     * 一句话识别demo。
     */
    private void vcsDemo() {
        registerVoice();
        synthesisVoice();
        listVoice();

    }

    private void registerVoice() {
        try {

            // 1. 初始化AsrCustomizationClient
            // 定义authInfo，根据ak，sk，region，projectId

            AuthInfo authInfo = new AuthInfo(ak, sk, region, projectId);

            // 设置config，主要与超时有关
            SisConfig config = getConfig();
            // 根据authInfo和config，构造AsrCustomizationClient
            VcsClient vcsClient = new VcsClient(authInfo, config);

            // 2. 配置请求
            String data = IOUtils.getEncodeDataByPath(path);
            String voiceName = "test_english_03";
            String language = "english";
            RegisterVoiceRequest request = new RegisterVoiceRequest(voiceName, data, language);

            // 3. 发送请求，获取响应。具体结果可通过response.getXX获取。
            RegisterVoiceResponse response = vcsClient.registerVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        } catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    private void synthesisVoice() {
        try {

            // 1. 初始化AsrCustomizationClient
            // 定义authInfo，根据ak，sk，region，projectId
            AuthInfo authInfo = new AuthInfo(ak, sk, region, projectId);
            // 设置config，主要与超时有关
            SisConfig config = getConfig();
            // 根据authInfo和config，构造AsrCustomizationClient
            VcsClient vcsClient = new VcsClient(authInfo, config);

            // 2. 配置请求
            String data = IOUtils.getEncodeDataByPath(path);
            String text = "this is a good idea!";
            String voiceName = "test_english_02"; // voice name 必须是一个之前成功注册的voice name
            VcsCloneRequest request = new VcsCloneRequest(voiceName, text);

            // 3. 发送请求，获取响应。具体结果可通过response.getXX获取。
            VoiceCloneResponse response = vcsClient.synthesisVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        } catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    private VoicesResponse listVoice() {
        try {

            // 1. 初始化AsrCustomizationClient
            // 定义authInfo，根据ak，sk，region，projectId
            AuthInfo authInfo = new AuthInfo(ak, sk, region, projectId);
            // 设置config，主要与超时有关
            SisConfig config = getConfig();
            // 根据authInfo和config，构造AsrCustomizationClient
            VcsClient vcsClient = new VcsClient(authInfo, config);

            // 2. 配置请求
            String data = IOUtils.getEncodeDataByPath(path);
            String text = "this is a good idea!";
            String voiceName = "test_english_01"; // voice name 必须是一个之前成功注册的voice name
            VcsCloneRequest request = new VcsCloneRequest(voiceName, text);

            // 3. 发送请求，获取响应。具体结果可通过response.getXX获取, 下面取前10个音色
            VoicesResponse response = vcsClient.query(0, 10);
            log.info(JsonUtils.obj2Str(response, true));
            return response;
        } catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
            return null;
        }
    }
}
