/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.util;

import com.cloud.sdk.http.HttpMethodName;
import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.bean.ProxyHostInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.exception.SisException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKHttpClientUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OKHttpClientUtils.class);
    private static final int TIME_TO_LIVE = 300;
    private static final int MAX_CONNECTIONS = 200;
    private static final int RETRY_COUNT = 5;

    public static Map<String, String> getJsonHeaders() {
        HashMap<String, String> jsonHeaders = new HashMap<String, String>();
        jsonHeaders.put("Content-Type", "application/json");
        return jsonHeaders;
    }

    public static Response getHttpResponse(OkHttpClient httpClient, Request request) throws SisException {
        try {
            Response response = httpClient.newCall(request).execute();
            return response;
        }
        catch (IOException e) {
            log.error("{} {} meets io error, exception is {}", new Object[]{request.method(), request.url().url().toString(), e.getMessage()});
            throw new SisException(request.method() + " " + request.url().url().toString() + "meets io error", e);
        }
        catch (NullPointerException e) {
            log.error("{} {} connect failed", (Object)request.method(), (Object)request.url().url().toString());
            throw new SisException(request.method() + " " + request.url().url().toString() + " connect failed");
        }
    }

    public static Response getHttpResponse(OkHttpClient httpClient, String url, Map<String, String> headers, String jsonBody, HttpMethodName httpMethodName) throws SisException {
        Request request = OKHttpClientUtils.getRequest(url, headers, jsonBody, httpMethodName);
        return OKHttpClientUtils.getHttpResponse(httpClient, request);
    }

    private static Request getRequest(String url, Map<String, String> headers, String jsonBody, HttpMethodName httpMethodName) throws SisException {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                requestBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        RequestBody requestBody = null;
        if (!StringUtils.isNullOrEmpty((String)jsonBody)) {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
            requestBody = RequestBody.create((MediaType)mediaType, (String)jsonBody);
        }
        if (httpMethodName == HttpMethodName.GET) {
            requestBuilder.get();
        } else if (httpMethodName == HttpMethodName.DELETE) {
            requestBuilder.delete();
        } else if (httpMethodName == HttpMethodName.POST) {
            requestBuilder.post(requestBody);
        } else if (httpMethodName == HttpMethodName.PUT) {
            requestBuilder.put(requestBody);
        } else {
            log.error("now don't support http {} method", (Object)httpMethodName);
            throw new SisException("now don't support http " + httpMethodName.toString() + " method");
        }
        return requestBuilder.build();
    }

    public static OkHttpClient getOkHttpClient(SisConfig sisConfig) {
        return OKHttpClientUtils.getOkHttpClient(sisConfig.getProxy(), sisConfig.getConnectionTimeout(), sisConfig.getReadTimeout(), sisConfig.getPingInterval(), sisConfig.isCertificateCheck());
    }

    public static OkHttpClient getOkHttpClient(ProxyHostInfo hostInfo, int connectionTimeout, int readTimeout, int pingInterval, boolean certificateCheck) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().retryOnConnectionFailure(true);
        clientBuilder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        if (pingInterval > 0) {
            clientBuilder.pingInterval((long)pingInterval, TimeUnit.MILLISECONDS);
        }
        if (hostInfo != null) {
            InetSocketAddress socketAddress = new InetSocketAddress(hostInfo.getHostName(), hostInfo.getPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, socketAddress);
            clientBuilder.proxy(proxy);
            if (!StringUtils.isNullOrEmpty((String)hostInfo.getPassword())) {
                Authenticator proxyAuthenticator = (route, response) -> {
                    String credential = Credentials.basic((String)hostInfo.getUserName(), (String)hostInfo.getPassword());
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                };
                clientBuilder.proxyAuthenticator(proxyAuthenticator);
            }
        }
        RetryIncerptor retryIncerptor = new RetryIncerptor();
        clientBuilder.addInterceptor((Interceptor)retryIncerptor);
        if (!certificateCheck) {
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLSocketFactory sslSocketFactory = null;
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
                sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                log.error("Configure ssl failed", (Throwable)e);
            }
            HostnameVerifier hostnameVerifier = (s, sslSession) -> true;
            if (sslSocketFactory != null) {
                clientBuilder.sslSocketFactory(sslSocketFactory, x509TrustManager).hostnameVerifier(hostnameVerifier);
            }
        }
        ConnectionPool connectionPool = new ConnectionPool(200, 300L, TimeUnit.SECONDS);
        clientBuilder.connectionPool(connectionPool);
        return clientBuilder.build();
    }

    public static class RetryIncerptor
    implements Interceptor {
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Response response = null;
            for (int retryNum = 0; retryNum < 5; ++retryNum) {
                try {
                    response = chain.proceed(request);
                    break;
                }
                catch (SocketTimeoutException e) {
                    log.error("now is {} retry, excpetion is {}", (Object)(retryNum + 1), (Object)e.getMessage());
                    continue;
                }
            }
            if (response == null) {
                log.error("retry {} failed, response is null", (Object)5);
            }
            return response;
        }
    }
}

