/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.util;

import com.cloud.apigateway.sdk.utils.Client;
import com.cloud.apigateway.sdk.utils.Request;
import com.cloud.sdk.http.HttpMethodName;
import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.UserInfo;
import com.huawei.sis.bean.request.GetTokenRequest;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;
import com.huawei.sis.util.ResponseProcessUtils;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthUtils.class);
    private static final int EXPIRE_TIME = 18000000;
    private static ConcurrentHashMap<String, String> tokenMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> timeMap = new ConcurrentHashMap();
    private static OkHttpClient okHttpClient = null;

    public static okhttp3.Request getSignedRequest(AuthInfo authInfo, String url, Map<String, String> headers, String jsonBody, HttpMethodName httpMethod) throws SisException {
        Request request = new Request();
        try {
            request.setAppKey(authInfo.getAk());
            request.setAppSecrect(authInfo.getSk());
            request.setMethod(httpMethod.toString());
            request.setUrl(url.split("\\?")[0]);
            if (url.contains("?") && url.contains("=")) {
                String[] paras;
                String parameters = url.substring(url.indexOf("?") + 1);
                for (String p : paras = parameters.split("&")) {
                    String key = p.split("=")[0];
                    String value = p.split("=")[1];
                    request.addQueryStringParam(key, value);
                }
            }
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (!StringUtils.isNullOrEmpty((String)jsonBody)) {
                request.setBody(jsonBody);
            }
            okhttp3.Request signedRequest = Client.signOkhttp((Request)request);
            return signedRequest;
        }
        catch (URISyntaxException e) {
            log.error("{} format is invalid, exception is {}", (Object)url, (Object)e.getMessage());
            throw new SisException(url + " format is invalid", e);
        }
        catch (Exception e) {
            log.error("apig sign failed\uff0curl is {}, exception is {}", (Object)url, (Object)e.getMessage());
            throw new SisException("apig sign failed, url is " + url, e);
        }
    }

    public static String getToken(UserInfo userInfo, SisConfig config) throws SisException {
        long tokenTime;
        String projectId = userInfo.getProjectId();
        long now = System.currentTimeMillis();
        if (tokenMap.containsKey(projectId) && timeMap.containsKey(projectId) && now - (tokenTime = timeMap.get(projectId).longValue()) < 18000000L) {
            log.info("use token cache");
            return tokenMap.get(projectId);
        }
        GetTokenRequest getTokenRequest = new GetTokenRequest(userInfo.getUserName(), userInfo.getPassword(), userInfo.getDomainName(), userInfo.getServiceRegion());
        String params = JsonUtils.obj2Str(getTokenRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String tokenUrl = userInfo.getTokenEndpoint() + "/v3/auth/tokens";
        okHttpClient = OKHttpClientUtils.getOkHttpClient(config);
        Response response = OKHttpClientUtils.getHttpResponse(okHttpClient, tokenUrl, headers, params, HttpMethodName.POST);
        String token = response.header("X-Subject-Token");
        if (token == null) {
            String text = ResponseProcessUtils.convertResponseToStr(response);
            log.error("Fail to get token, url is {}, response message is {}", (Object)tokenUrl, (Object)text);
            throw new SisException("Fail to get token, response message is " + text);
        }
        tokenMap.put(projectId, token);
        timeMap.put(projectId, now);
        ResponseProcessUtils.closeResponse(response);
        return token;
    }
}

