/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.service;

import com.cloud.sdk.http.HttpMethodName;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.UserInfo;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.AuthUtils;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.OKHttpClientUtils;
import java.util.Map;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketService.class);
    private static final int MAX_BYTE_LEN = 25000;
    private static final int MIN_BYTE_LEN = 2000;
    private static final int MAX_SLEEP_TIME = 500;
    private static final int MIN_SLEEP_TIME = 30;
    private static final int DEFAULT_SEND_BYTE = 3200;
    private static final int DEFAULT_SLEEP_TIME = 50;
    private static final int CLOSE_CODE = 1000;
    private SisConfig config;
    private AuthInfo authInfo;
    private UserInfo userInfo;
    private WebSocketListener listener;
    private OkHttpClient httpClient;
    private WebSocket webSocket;
    private String clientId;

    public WebSocketService(AuthInfo authInfo, SisConfig config, WebSocketListener listener) {
        this.authInfo = authInfo;
        this.config = config;
        this.httpClient = OKHttpClientUtils.getOkHttpClient(config);
        this.listener = listener;
    }

    public WebSocketService(AuthInfo authInfo, SisConfig config, WebSocketListener listener, String clientId) {
        this.authInfo = authInfo;
        this.config = config;
        this.httpClient = OKHttpClientUtils.getOkHttpClient(config);
        this.listener = listener;
        this.clientId = clientId;
    }

    @Deprecated
    public WebSocketService(UserInfo userInfo, SisConfig config, WebSocketListener listener) {
        this.config = config;
        this.userInfo = userInfo;
        this.httpClient = OKHttpClientUtils.getOkHttpClient(config);
        this.listener = listener;
    }

    public void connectWebsocket(String url, Map<String, String> headers) throws SisException {
        if (this.userInfo == null && this.authInfo == null) {
            log.error("Invalid init, AuthInfo and UserInfo are both null, you should at least set one in constructor");
            throw new SisException("Invalid init, AuthInfo and UserInfo are both null, you should at least set one in constructor");
        }
        Request request = this.userInfo == null ? this.getAuthInfoRequest(url, headers) : this.getUserInfoRequest(url, headers);
        this.webSocket = this.httpClient.newWebSocket(request, this.listener);
    }

    public void closeWebsocket() {
        if (this.webSocket != null) {
            this.webSocket.close(1000, null);
        }
    }

    public void sendFileData(String filePath) throws SisException {
        this.sendFileData(filePath, 3200, 50);
    }

    public void sendFileData(String filePath, int byteLen, int sleepTime) throws SisException {
        this.checkParameter(byteLen, sleepTime);
        byte[] data = IOUtils.getFileData(filePath);
        this.sendByteData(data, byteLen, sleepTime);
        log.debug("Success to send audio {}", (Object)filePath);
    }

    public void sendByteData(byte[] data, int byteSend, int sleepTime) throws SisException {
        this.checkParameter(byteSend, sleepTime);
        for (int i = 0; i < data.length; i += byteSend) {
            log.info("client_id {} send chunk {} size {}", new Object[]{this.clientId, i / byteSend + 1, byteSend});
            int data0Len = Math.min(byteSend, data.length - i);
            byte[] data0 = new byte[data0Len];
            System.arraycopy(data, i, data0, 0, data0Len);
            this.webSocket.send(ByteString.of((byte[])data0));
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                log.error("Thread sleeps failed, sleepTime is {}, exception is {}", (Object)sleepTime, (Object)e.getMessage());
                throw new SisException("Thread sleeps failed, sleepTime=" + sleepTime, e);
            }
        }
    }

    public void sendByteData(byte[] data) throws SisException {
        this.sendByteData(data, 3200, 50);
    }

    public void sendStrData(String message) {
        this.webSocket.send(message);
    }

    private void checkParameter(int byteLen, int sleepTime) throws SisException {
        if (byteLen > 25000 || byteLen < 2000) {
            String errorMessage = "byteLen=" + byteLen + ", we suggest it in [" + 2000 + ", " + 25000 + "]";
            log.error(errorMessage);
            throw new SisException(errorMessage);
        }
        if (sleepTime == 0) {
            return;
        }
        if (sleepTime > 500 || sleepTime < 30) {
            String errorMessage = "sleepTime=" + sleepTime + ", we suggest it in [" + 30 + ", " + 500 + "]. If the audio is acquired by recording device, you can set sleep time 0";
            log.error(errorMessage);
            throw new SisException(errorMessage);
        }
    }

    private Request getUserInfoRequest(String url, Map<String, String> headers) throws SisException {
        String token = AuthUtils.getToken(this.userInfo, this.config);
        Request.Builder builder = new Request.Builder().url(url).addHeader("X-Auth-Token", token);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    private Request getAuthInfoRequest(String url, Map<String, String> headers) throws SisException {
        String httpUrl = url.replace("ws", "http");
        Request request = AuthUtils.getSignedRequest(this.authInfo, httpUrl, headers, null, HttpMethodName.GET);
        return request;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }
}

