/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.service;

import com.huawei.sis.bean.RttsListener;
import com.huawei.sis.bean.SisEnum;
import com.huawei.sis.bean.response.RttsDataResponse;
import com.huawei.sis.bean.response.RttsTextResponse;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RttsService
extends WebSocketListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RttsService.class);
    private SisEnum.WebsocketStatus status;
    private CountDownLatch connectLatch;
    private CountDownLatch sendLatch;
    private RttsListener rttsListener;

    public RttsService(RttsListener rttsListener) {
        this.rttsListener = rttsListener;
        this.status = SisEnum.WebsocketStatus.STATE_INIT;
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        if (webSocket != null) {
            webSocket.close(1000, "normal");
        }
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.status = SisEnum.WebsocketStatus.STATE_CONNECTED;
        if (this.connectLatch != null) {
            this.connectLatch.countDown();
        }
        this.rttsListener.onTranscriptionConnect();
        log.debug("websocket connected");
    }

    public void onMessage(WebSocket websocket, String text) {
        try {
            String resultType;
            RttsTextResponse rttsTextResponse = JsonUtils.str2Obj(text, RttsTextResponse.class);
            switch (resultType = rttsTextResponse.getRespType()) {
                case "START": {
                    this.status = SisEnum.WebsocketStatus.STATE_START;
                    StateResponse stateResponse = new StateResponse("start", rttsTextResponse.getTraceId(), "start to synthesis text");
                    this.rttsListener.onTranscriptionBegin(stateResponse);
                    break;
                }
                case "END": {
                    this.status = SisEnum.WebsocketStatus.STATE_END;
                    if (this.sendLatch != null) {
                        this.sendLatch.countDown();
                    }
                    StateResponse stateResponse = new StateResponse("end", rttsTextResponse.getTraceId(), rttsTextResponse.getReason());
                    this.rttsListener.onSTranscriptionEnd(stateResponse);
                    break;
                }
                case "ERROR": 
                case "FATAL_ERROR": {
                    this.status = SisEnum.WebsocketStatus.STATE_ERROR;
                    this.clearLatch();
                    log.error("receive error resp from server {}", (Object)text);
                    StateResponse stateResponse = new StateResponse("error", rttsTextResponse.getTraceId(), text);
                    this.rttsListener.onTranscriptionFail(stateResponse);
                    break;
                }
                default: {
                    log.warn("traceId {}, respType {}, is invalid", (Object)rttsTextResponse.getTraceId(), (Object)resultType);
                    break;
                }
            }
        }
        catch (SisException e) {
            log.error("websocket response {} can't be prased, error_code is {}, error_msg is {}", new Object[]{text, e.getErrorCode(), e.getErrorMsg()});
            return;
        }
    }

    public void onMessage(WebSocket webSocket, ByteString byteString) {
        byte[] data = byteString.toByteArray();
        RttsDataResponse rttsDataResponse = new RttsDataResponse();
        rttsDataResponse.setData(data);
        this.rttsListener.onTranscriptionResponse(rttsDataResponse);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.status = SisEnum.WebsocketStatus.STATE_CLOSE;
        this.clearLatch();
        this.rttsListener.onTranscriptionClose();
        log.debug("websocket closed, {}", (Object)reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.status = SisEnum.WebsocketStatus.STATE_ERROR;
        this.clearLatch();
        log.error("websocket connect failed", t);
        StateResponse stateResponse = new StateResponse(this.status.getStatus(), "", t.getMessage());
        this.rttsListener.onTranscriptionFail(stateResponse);
    }

    private void clearLatch() {
        if (this.connectLatch != null) {
            this.connectLatch.countDown();
        }
        if (this.sendLatch != null) {
            this.sendLatch.countDown();
        }
    }

    @Generated
    public void setStatus(SisEnum.WebsocketStatus status) {
        this.status = status;
    }

    @Generated
    public SisEnum.WebsocketStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setConnectLatch(CountDownLatch connectLatch) {
        this.connectLatch = connectLatch;
    }

    @Generated
    public void setSendLatch(CountDownLatch sendLatch) {
        this.sendLatch = sendLatch;
    }
}

