/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.service;

import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.bean.RasrListener;
import com.huawei.sis.bean.SisEnum;
import com.huawei.sis.bean.response.RasrResponse;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasrService
extends WebSocketListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RasrService.class);
    private SisEnum.WebsocketStatus status;
    private RasrListener rasrListener;
    private CountDownLatch startLatch;
    private CountDownLatch endLatch;
    private CountDownLatch connectLatch;
    private String clientId;
    private int receiveCount = 0;

    public RasrService(RasrListener rasrListener, String clientId) {
        this.clientId = clientId;
        this.rasrListener = rasrListener;
        this.status = SisEnum.WebsocketStatus.STATE_INIT;
    }

    public RasrService(RasrListener rasrListener) {
        this.rasrListener = rasrListener;
        this.status = SisEnum.WebsocketStatus.STATE_INIT;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.processConnect();
    }

    public void onMessage(WebSocket webSocket, String text) {
        try {
            RasrResponse rasrResponse = JsonUtils.str2Obj(text, RasrResponse.class);
            String resultType = rasrResponse.getRespTyep();
            if (resultType.equals("START")) {
                this.processStart(rasrResponse);
            } else if (resultType.equals("EVENT")) {
                this.processEvent(rasrResponse);
            } else if (resultType.equals("END")) {
                this.processEnd(rasrResponse, "the connection ended in normal way");
            } else if (resultType.equals("ERROR") || resultType.equals("FATAL_ERROR")) {
                this.processError(rasrResponse, JsonUtils.obj2Str(rasrResponse));
            } else if (resultType.equals("RESULT")) {
                this.processResult(rasrResponse);
            } else {
                log.error("{} doesn't belong to any type", (Object)resultType);
            }
        }
        catch (SisException e) {
            log.error("websocket response {} can't be prased, error_code is {}, error_msg is {}", new Object[]{text, e.getErrorCode(), e.getErrorMsg()});
            return;
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        if (webSocket != null) {
            webSocket.close(1000, "normal");
        }
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.processClose(reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        log.error("client_id {} websocket connect failed, error_msg is {}", (Object)this.clientId, (Object)t.getMessage());
        this.processError(null, t.getMessage());
    }

    private void processConnect() {
        this.status = SisEnum.WebsocketStatus.STATE_CONNECTED;
        if (this.connectLatch != null) {
            this.connectLatch.countDown();
        }
        this.rasrListener.onTranscriptionConnect();
        log.debug("client_id {} Websocket connected", (Object)this.clientId);
    }

    private void processClose(String message) {
        this.status = SisEnum.WebsocketStatus.STATE_CLOSE;
        this.clearLatch();
        this.rasrListener.onTranscriptionClose();
        log.debug("websocket closed, {}", (Object)message);
    }

    private void processStart(RasrResponse rasrResponse) {
        this.status = SisEnum.WebsocketStatus.STATE_START;
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        StateResponse response = new StateResponse("start", rasrResponse.getTraceId(), "start to recognize audio");
        this.rasrListener.onTranscriptionBegin(response);
    }

    private void processEnd(RasrResponse rasrResponse, String message) {
        this.status = SisEnum.WebsocketStatus.STATE_END;
        if (this.endLatch != null) {
            this.endLatch.countDown();
        }
        StateResponse response = new StateResponse("end", rasrResponse.getTraceId(), message);
        this.rasrListener.onSTranscriptionEnd(response);
        log.debug("websocket ended, {}", (Object)message);
    }

    private void processError(RasrResponse rasrResponse, String message) {
        String traceId = "";
        if (rasrResponse != null) {
            traceId = rasrResponse.getTraceId();
        }
        log.error("TraceId is {}, receive error msg is {}, now status is {}", new Object[]{traceId, message, this.status.getStatus()});
        this.status = SisEnum.WebsocketStatus.STATE_ERROR;
        this.clearLatch();
        StateResponse response = new StateResponse("error", traceId, message);
        this.rasrListener.onTranscriptionFail(response);
    }

    private void processEvent(RasrResponse rasrResponse) {
        String event = rasrResponse.getEvent();
        if (StringUtils.isNullOrEmpty((String)event)) {
            log.error("event is empty");
            return;
        }
        this.rasrListener.onEvent(event);
        switch (event) {
            case "EXCEEDED_AUDIO": {
                this.rasrListener.onExceededAudio();
                break;
            }
            case "VOICE_START": {
                this.rasrListener.onVoiceStart();
                break;
            }
            case "VOICE_END": {
                this.rasrListener.onVoiceEnd();
                break;
            }
            case "EXCEEDED_SILENCE": {
                this.rasrListener.onExcceededSilence();
                break;
            }
        }
    }

    private void processResult(RasrResponse rasrResponse) {
        this.rasrListener.onTranscriptionResponse(rasrResponse);
        log.info("client_id {} receive {} result", (Object)this.clientId, (Object)(++this.receiveCount));
    }

    private void clearLatch() {
        if (this.startLatch != null) {
            this.startLatch.countDown();
        }
        if (this.endLatch != null) {
            this.endLatch.countDown();
        }
        if (this.connectLatch != null) {
            this.connectLatch.countDown();
        }
    }

    @Generated
    public void setStatus(SisEnum.WebsocketStatus status) {
        this.status = status;
    }

    @Generated
    public SisEnum.WebsocketStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStartLatch(CountDownLatch startLatch) {
        this.startLatch = startLatch;
    }

    @Generated
    public void setEndLatch(CountDownLatch endLatch) {
        this.endLatch = endLatch;
    }

    @Generated
    public void setConnectLatch(CountDownLatch connectLatch) {
        this.connectLatch = connectLatch;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }
}

