/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.intl_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.AsrCustomShortRequest;
import com.huawei.sis.bean.response.AsrCustomShortResponse;
import com.huawei.sis.client.AsrCustomizationClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.IOUtils;

public class AsrCustomizationDemo {
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String path = "";
    private String pathAudioFormat = "";
    private String pathProperty = "";

    private void setShortParameter(AsrCustomShortRequest request) {
        request.setAddPunc("yes");
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setRequestTimeout(10000);
        config.setSocketTimeout(10000);
        return config;
    }

    private void printAsrShortResponse(AsrCustomShortResponse response) {
        System.out.println("traceId=" + response.getTraceId());
        System.out.println("text=" + response.getText());
        System.out.println("score=" + response.getScore());
        System.out.println("\n");
    }

    private void shortDemo() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            AsrCustomizationClient asr = new AsrCustomizationClient(authInfo, config);
            String data = IOUtils.getEncodeDataByPath(this.path);
            AsrCustomShortRequest request = new AsrCustomShortRequest(data, this.pathAudioFormat, this.pathProperty);
            this.setShortParameter(request);
            AsrCustomShortResponse response = asr.getAsrShortResponse(request);
            this.printAsrShortResponse(response);
        }
        catch (SisException e) {
            e.printStackTrace();
            System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    public static void main(String[] args) {
        AsrCustomizationDemo demo = new AsrCustomizationDemo();
        demo.shortDemo();
    }
}

