/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.RegisterVoiceRequest;
import com.huawei.sis.bean.request.VcsCloneRequest;
import com.huawei.sis.bean.response.RegisterVoiceResponse;
import com.huawei.sis.bean.response.VoiceCloneResponse;
import com.huawei.sis.bean.response.VoicesResponse;
import com.huawei.sis.client.VcsClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsDemo {
    private static final Logger log = LoggerFactory.getLogger(VcsDemo.class);
    String path = "D:\\test.mp3";
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String endPoint = "";

    public static void main(String[] args) {
        VcsDemo demo = new VcsDemo();
        demo.vcsDemo();
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void vcsDemo() {
        this.registerVoice();
        this.synthesisVoice();
        this.listVoice();
    }

    private void registerVoice() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            VcsClient vcsClient = new VcsClient(authInfo, config);
            String data = IOUtils.getEncodeDataByPath(this.path);
            String voiceName = "test_english_03";
            String language = "english";
            RegisterVoiceRequest request = new RegisterVoiceRequest(voiceName, data, language);
            RegisterVoiceResponse response = vcsClient.registerVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    private void synthesisVoice() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            VcsClient vcsClient = new VcsClient(authInfo, config);
            String data = IOUtils.getEncodeDataByPath(this.path);
            String text = "this is a good idea!";
            String voiceName = "test_english_02";
            VcsCloneRequest request = new VcsCloneRequest(voiceName, text);
            VoiceCloneResponse response = vcsClient.synthesisVoice(request);
            log.info(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    private VoicesResponse listVoice() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            VcsClient vcsClient = new VcsClient(authInfo, config);
            String data = IOUtils.getEncodeDataByPath(this.path);
            String text = "this is a good idea!";
            String voiceName = "test_english_01";
            VcsCloneRequest request = new VcsCloneRequest(voiceName, text);
            VoicesResponse response = vcsClient.query(0, 10);
            log.info(JsonUtils.obj2Str(response, true));
            return response;
        }
        catch (SisException e) {
            log.info("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
            return null;
        }
    }
}

