/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.TtsCustomRequest;
import com.huawei.sis.bean.response.TtsCustomResponse;
import com.huawei.sis.client.TtsCustomizationClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;

public class TtsDemo {
    private static final int DEFAULT_PITCH = 0;
    private static final int DEFAULT_SPEED = 0;
    private static final int DEFAULT_VOLUME = 50;
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String text = "";
    private String path = "";

    private void setParameter(TtsCustomRequest request) {
        request.setAudioFormat("wav");
        request.setPitch(0);
        request.setSpeed(0);
        request.setVolume(50);
        request.setSampleRate("8000");
        request.setProperty("chinese_xiaoyu_common");
        request.setSaved(true);
        request.setSavePath(this.path);
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void ttsCustomDemo() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            TtsCustomizationClient tts = new TtsCustomizationClient(authInfo, config);
            TtsCustomRequest request = new TtsCustomRequest(this.text);
            this.setParameter(request);
            TtsCustomResponse response = tts.getTtsResponse(request);
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            e.printStackTrace();
            System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    public static void main(String[] args) {
        TtsDemo demo = new TtsDemo();
        demo.ttsCustomDemo();
    }
}

