/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.AsrCustomShortRequest;
import com.huawei.sis.bean.response.AsrCustomShortResponse;
import com.huawei.sis.client.AsrCustomizationClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.JsonUtils;

public class SasrDemo {
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String path = "";
    private String pathAudioFormat = "";
    private String pathProperty = "";

    private void setShortParameter(AsrCustomShortRequest request) {
        request.setAddPunc("yes");
        request.setDigitNorm("no");
        request.setNeedWordInfo("no");
        request.setAutoLanguageDetect("no");
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void sasrDemo() {
        try {
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            AsrCustomizationClient asr = new AsrCustomizationClient(authInfo, config);
            String data = IOUtils.getEncodeDataByPath(this.path);
            AsrCustomShortRequest request = new AsrCustomShortRequest(data, this.pathAudioFormat, this.pathProperty);
            this.setShortParameter(request);
            AsrCustomShortResponse response = asr.getAsrShortResponse(request);
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            e.printStackTrace();
            System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    public static void main(String[] args) {
        SasrDemo demo = new SasrDemo();
        demo.sasrDemo();
    }
}

