/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.RasrListener;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.RasrRequest;
import com.huawei.sis.bean.response.RasrResponse;
import com.huawei.sis.bean.response.StateResponse;
import com.huawei.sis.client.RasrClient;
import com.huawei.sis.util.JsonUtils;

public class RasrDemo {
    private static final int DEFAULT_HEAD_SILENCE_TIME = 1000;
    private static final int DEFAULT_TAIL_SILENCE_TIME = 500;
    private static final int DEFAULT_CONTINUE_SECONDS = 30;
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String path = "";
    private String audioFormat = "";
    private String property = "";

    private void setParameters(RasrRequest request) {
        request.setAddPunc("yes");
        request.setVadHead(1000);
        request.setVadTail(500);
        request.setMaxSeconds(30);
        request.setIntermediateResult("no");
        request.setDigitNorm("no");
        request.setNeedWordInfo("no");
        request.setNeedSmooth("no");
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private RasrListener getRasrListener() {
        RasrListener rasrListener = new RasrListener(){

            @Override
            public void onTranscriptionConnect() {
                System.out.println("websocket connected");
            }

            @Override
            public void onTranscriptionClose() {
                System.out.println("websocket closed");
            }

            @Override
            public void onTranscriptionResponse(RasrResponse response) {
                RasrDemo.this.printResponse(response);
            }

            @Override
            public void onTranscriptionBegin(StateResponse response) {
                RasrDemo.this.printResponse(response);
            }

            @Override
            public void onSTranscriptionEnd(StateResponse response) {
                RasrDemo.this.printResponse(response);
            }

            @Override
            public void onTranscriptionFail(StateResponse response) {
                RasrDemo.this.printResponse(response);
            }
        };
        return rasrListener;
    }

    private void printResponse(Object response) {
        try {
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process() {
        try {
            RasrListener rasrListener = this.getRasrListener();
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            RasrClient rasrClient = new RasrClient(authInfo, rasrListener, this.getConfig());
            RasrRequest request = new RasrRequest(this.audioFormat, this.property);
            this.setParameters(request);
            rasrClient.continueStreamConnect(request);
            rasrClient.sendStart();
            rasrClient.sendAudio(this.path);
            rasrClient.sendEnd();
            rasrClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        RasrDemo rasrDemo = new RasrDemo();
        rasrDemo.process();
    }
}

