/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.demo.cn_demo;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.AsrCustomLongRequest;
import com.huawei.sis.bean.response.AsrCustomLongResponse;
import com.huawei.sis.client.AsrCustomizationClient;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;

public class LasrDemo {
    private static final int SLEEP_TIME = 500;
    private static final int MAX_POLLING_NUMS = 1000;
    private String ak = System.getenv("HUAWEICLOUD_SDK_AK");
    private String sk = System.getenv("HUAWEICLOUD_SDK_SK");
    private String region = "";
    private String projectId = "";
    private String obsUrl = "";
    private String obsAudioFormat = "";
    private String obsProperty = "";

    private void setLongParameter(AsrCustomLongRequest request) {
        request.setAddPunc("yes");
        request.setDigitNorm("no");
        request.setNeedAnalysis(true);
        request.setChannel("MONO");
        request.setDirization(true);
        request.setEmotion(true);
        request.setSpeed(true);
        request.setNeedWordInfo("no");
    }

    private SisConfig getConfig() {
        SisConfig config = new SisConfig();
        config.setConnectionTimeout(10000);
        config.setReadTimeout(10000);
        return config;
    }

    private void lasrDemo() {
        try {
            int count;
            AuthInfo authInfo = new AuthInfo(this.ak, this.sk, this.region, this.projectId);
            SisConfig config = this.getConfig();
            AsrCustomizationClient asr = new AsrCustomizationClient(authInfo, config);
            AsrCustomLongRequest request = new AsrCustomLongRequest(this.obsUrl, this.obsAudioFormat, this.obsProperty);
            this.setLongParameter(request);
            String jobId = asr.submitJob(request);
            boolean successFlag = false;
            AsrCustomLongResponse response = null;
            for (count = 0; count < 1000; ++count) {
                System.out.println("\u6b63\u5728\u8fdb\u884c\u7b2c" + count + "\u6b21\u5c1d\u8bd5");
                response = asr.getAsrLongResponse(jobId);
                String status = response.getStatus();
                if (status.equals("FINISHED")) {
                    successFlag = true;
                    break;
                }
                if (status.equals("ERROR")) {
                    System.out.println("\u6267\u884c\u5931\u8d25, \u65e0\u6cd5\u6839\u636ejobId\u83b7\u53d6\u7ed3\u679c");
                    return;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!successFlag) {
                System.out.println("\u5df2\u8fdb\u884c" + count + "\u6b21\u5c1d\u8bd5\uff0c\u65e0\u6cd5\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c\u3002 jobId\u4e3a " + jobId);
                return;
            }
            System.out.println(JsonUtils.obj2Str(response, true));
        }
        catch (SisException e) {
            e.printStackTrace();
            System.out.println("error_code:" + e.getErrorCode() + "\nerror_msg:" + e.getErrorMsg());
        }
    }

    public static void main(String[] args) {
        LasrDemo demo = new LasrDemo();
        demo.lasrDemo();
    }
}

