/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.cloud.sdk.http.HttpMethodName;
import com.cloud.sdk.util.StringUtils;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.RegisterVoiceRequest;
import com.huawei.sis.bean.request.VcsCloneRequest;
import com.huawei.sis.bean.response.RegisterVoiceResponse;
import com.huawei.sis.bean.response.VoiceCloneResponse;
import com.huawei.sis.bean.response.VoicesResponse;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.HttpService;
import com.huawei.sis.util.IOUtils;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;

public class VcsClient {
    private AuthInfo authInfo = null;
    private HttpService httpService = null;
    private String registerUrl;
    private String synthesisUrl;

    public VcsClient(AuthInfo authinfo, SisConfig config) {
        this.authInfo = authinfo;
        this.httpService = new HttpService(this.authInfo, config);
        this.registerUrl = authinfo.getServiceEndPoint() + "/v1/" + authinfo.getProjectId() + "/vcs/voices";
        this.synthesisUrl = authinfo.getServiceEndPoint() + "/v1/" + authinfo.getProjectId() + "/vcs/voices/clone";
    }

    public VcsClient(AuthInfo authInfo) {
        this(authInfo, new SisConfig());
    }

    public RegisterVoiceResponse registerVoice(RegisterVoiceRequest request) throws SisException {
        String params = request.constructParams();
        if (StringUtils.isNullOrEmpty((String)request.getVoiceConfig().getVoiceName()) || StringUtils.isNullOrEmpty((String)request.getVoiceConfig().getLanguage())) {
            throw new SisException("voice name and language can not be empty!");
        }
        if (!request.getVoiceConfig().getLanguage().equals("chinese") && !request.getVoiceConfig().getLanguage().equals("english")) {
            throw new SisException("language should be chinese or english!");
        }
        if (StringUtils.isNullOrEmpty((String)request.getData())) {
            throw new SisException("voice audio data can not be empty!");
        }
        String result = this.httpService.getHttpApiResponse(this.registerUrl, OKHttpClientUtils.getJsonHeaders(), params, HttpMethodName.POST);
        RegisterVoiceResponse response = JsonUtils.str2Obj(result, RegisterVoiceResponse.class);
        return response;
    }

    public VoiceCloneResponse synthesisVoice(VcsCloneRequest request) throws SisException {
        String params = request.constructParams();
        if (StringUtils.isNullOrEmpty((String)request.getVoiceCloneConfig().getVoiceName())) {
            throw new SisException("voice name can not be empty!");
        }
        if (StringUtils.isNullOrEmpty((String)request.getUserInputText())) {
            throw new SisException("input text can not be empty!");
        }
        String result = this.httpService.getHttpApiResponse(this.synthesisUrl, OKHttpClientUtils.getJsonHeaders(), params, HttpMethodName.POST);
        VoiceCloneResponse response = JsonUtils.str2Obj(result, VoiceCloneResponse.class);
        if (request.isSaved()) {
            IOUtils.writeTtsFile(response.getResult().getData(), request.getSavePath());
            response.setSaved(request.isSaved());
            response.setSavePath(request.getSavePath());
        }
        return response;
    }

    public VoicesResponse query(int limit, int offset) throws SisException {
        String url = this.registerUrl;
        int currentPageLimit = 0;
        int currentPageOffset = 0;
        if (limit < 0 || limit > 100) {
            currentPageLimit = 100;
        } else {
            currentPageOffset = limit;
        }
        if (offset < 0) {
            currentPageOffset = 10;
        }
        this.registerUrl = this.registerUrl + "?limit=" + currentPageLimit + "&offset=" + currentPageOffset;
        String result = this.httpService.getHttpApiResponse(url, OKHttpClientUtils.getJsonHeaders(), "", HttpMethodName.GET);
        return JsonUtils.str2Obj(result, VoicesResponse.class);
    }
}

