/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.RasrListener;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.SisEnum;
import com.huawei.sis.bean.UserInfo;
import com.huawei.sis.bean.request.RasrRequest;
import com.huawei.sis.bean.request.SasrWebsocketRequest;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.RasrService;
import com.huawei.sis.service.WebSocketService;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasrClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RasrClient.class);
    private static final int WAIT_TIME = 20;
    private WebSocketService ws = null;
    private RasrRequest request;
    private UserInfo userInfo;
    private AuthInfo authInfo;
    private SisConfig config;
    private RasrService rasrService;
    private CountDownLatch startLatch;
    private CountDownLatch endLatch;
    private CountDownLatch connectLatch;
    private String clientId;

    @Deprecated
    public RasrClient(UserInfo userInfo, RasrListener rasrListener) {
        this(userInfo, rasrListener, new SisConfig());
    }

    @Deprecated
    public RasrClient(UserInfo userInfo, RasrListener rasrListener, SisConfig config) {
        this.userInfo = userInfo;
        this.rasrService = new RasrService(rasrListener);
        this.ws = new WebSocketService(userInfo, config, (WebSocketListener)this.rasrService);
        this.config = config;
    }

    public RasrClient(AuthInfo authInfo, RasrListener rasrListener) {
        this(authInfo, rasrListener, new SisConfig());
    }

    public RasrClient(AuthInfo authInfo, RasrListener rasrListener, SisConfig config) {
        this.clientId = UUID.randomUUID().toString();
        this.authInfo = authInfo;
        this.rasrService = new RasrService(rasrListener, this.clientId);
        this.ws = new WebSocketService(authInfo, config, this.rasrService, this.clientId);
        this.config = config;
    }

    public void continueStreamConnect(RasrRequest rasrRequest) throws SisException {
        this.continueStreamConnect(null, rasrRequest);
    }

    public void continueStreamConnect(Map<String, String> headers, RasrRequest rasrRequest) throws SisException {
        this.connect(this.generateUrl("/rasr/continue-stream"), headers);
        this.request = rasrRequest;
    }

    public void shortStreamConnect(Map<String, String> headers, RasrRequest rasrRequest) throws SisException {
        this.connect(this.generateUrl("/rasr/short-stream"), headers);
        this.request = rasrRequest;
    }

    public void shortStreamConnect(RasrRequest rasrRequest) throws SisException {
        this.shortStreamConnect(null, rasrRequest);
    }

    public void sentenceStreamConnect(Map<String, String> headers, RasrRequest rasrRequest) throws SisException {
        this.connect(this.generateUrl("/rasr/sentence-stream"), headers);
        this.request = rasrRequest;
    }

    public void sentenceStreamConnect(RasrRequest rasrRequest) throws SisException {
        this.sentenceStreamConnect(null, rasrRequest);
    }

    public void sasrConnect(Map<String, String> headers, SasrWebsocketRequest sasrWebsocketRequest) throws SisException {
        this.connect(this.generateUrl("/asr/short-audio"), headers);
        this.request = sasrWebsocketRequest;
    }

    public void sasrConnect(SasrWebsocketRequest sasrWebsocketRequest) throws SisException {
        this.sasrConnect(null, sasrWebsocketRequest);
    }

    public void sendStart() throws SisException {
        long startTime = System.currentTimeMillis();
        log.info("client_id {} send start command", (Object)this.clientId);
        try {
            if (this.checkStart()) {
                this.startLatch = new CountDownLatch(1);
                this.rasrService.setStatus(SisEnum.WebsocketStatus.STATE_START_WAITING);
                this.rasrService.setStartLatch(this.startLatch);
                this.ws.sendStrData(this.request.constructParams());
                if (!this.startLatch.await(20L, TimeUnit.SECONDS)) {
                    log.error("sdk don't receive start response in 20 seconds");
                    throw new SisException("sdk don't receive start response in 20 seconds");
                }
                log.info("client_id {} receive start command response, during {}ms", (Object)this.clientId, (Object)(System.currentTimeMillis() - startTime));
            }
        }
        catch (InterruptedException e) {
            log.error("wait start response occurs interrrupted exception", (Throwable)e);
            throw new SisException("wait start response occurs interrrupted exception");
        }
    }

    public void sendAudio(String filePath, int byteLen, int sleepTime) throws SisException {
        if (this.checkBinary()) {
            this.ws.sendFileData(filePath, byteLen, sleepTime);
        }
    }

    public void sendAudio(String filePath) throws SisException {
        if (this.checkBinary()) {
            this.ws.sendFileData(filePath);
        }
    }

    public void sendByte(byte[] data, int byteSend, int sleepTime) throws SisException {
        if (this.checkBinary()) {
            this.ws.sendByteData(data, byteSend, sleepTime);
        }
    }

    public void sendByte(byte[] data) throws SisException {
        if (this.checkBinary()) {
            this.ws.sendByteData(data);
        }
    }

    public void sendEnd() throws SisException {
        try {
            if (this.checkEnd()) {
                this.endLatch = new CountDownLatch(1);
                this.rasrService.setEndLatch(this.endLatch);
                this.rasrService.setStatus(SisEnum.WebsocketStatus.STATE_END_WAITING);
                this.ws.sendStrData("{  \"command\": \"END\",  \"cancel\": false}");
                if (!this.endLatch.await(20L, TimeUnit.SECONDS)) {
                    log.error("sdk don't receive end response in 20 seconds");
                    throw new SisException("sdk don't receive end response in 20 seconds");
                }
            }
        }
        catch (InterruptedException e) {
            log.error("wait end response occurs interrrupted exception", (Throwable)e);
            throw new SisException("wait end response occurs interrrupted exception");
        }
    }

    public void close() {
        this.rasrService.setStatus(SisEnum.WebsocketStatus.STATE_CLOSE);
        this.ws.closeWebsocket();
    }

    private String generateUrl(String api) throws SisException {
        String endpoint;
        String projectId;
        if (this.authInfo != null) {
            projectId = this.authInfo.getProjectId();
            endpoint = this.authInfo.getServiceEndPoint();
        } else if (this.userInfo != null) {
            projectId = this.userInfo.getProjectId();
            endpoint = this.userInfo.getServiceEndpoint();
        } else {
            log.error("Invalid init, AuthInfo and UserInfo are both null, you should at least set one in constructor");
            throw new SisException("Invalid init, AuthInfo and UserInfo are both null, you should at least set one in constructor");
        }
        String url = endpoint + "/v1/" + projectId + api;
        return url;
    }

    private void connect(String url, Map<String, String> headers) throws SisException {
        log.info("client_id {} start to connect service", (Object)this.clientId);
        try {
            if (this.checkConnect()) {
                this.connectLatch = new CountDownLatch(1);
                this.rasrService.setConnectLatch(this.connectLatch);
                this.rasrService.setStatus(SisEnum.WebsocketStatus.STATE_CONNECT_WAITING);
                this.ws.connectWebsocket(url, headers);
                if (!this.connectLatch.await(20L, TimeUnit.SECONDS)) {
                    log.error("connect to {} failed", (Object)url);
                    throw new SisException("connect to server failed in 20 seconds");
                }
            }
        }
        catch (InterruptedException e) {
            log.error("connect to {} occurs interrupt exception {}", (Object)url, (Object)e.getMessage());
            throw new SisException("connect rasr occurs interrupt exception");
        }
    }

    private boolean checkStart() throws SisException {
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_CONNECTED || this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
            return true;
        }
        log.error("status {} can't send start", (Object)this.rasrService.getStatus().getStatus());
        throw new SisException("status " + this.rasrService.getStatus().getStatus() + " can't send start");
    }

    private boolean checkBinary() throws SisException {
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_START) {
            return true;
        }
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
            log.warn("status {} can't send binary data, only support status start", (Object)this.rasrService.getStatus().getStatus());
            return false;
        }
        log.error("status {} can't send binary data", (Object)this.rasrService.getStatus().getStatus());
        throw new SisException("status " + this.rasrService.getStatus().getStatus() + " can't send binary data");
    }

    private boolean checkEnd() throws SisException {
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_START) {
            return true;
        }
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_END) {
            log.warn("status {} can't send end, only support status start", (Object)this.rasrService.getStatus().getStatus());
            return false;
        }
        log.error("status {} can't send end, only support status start", (Object)this.rasrService.getStatus().getStatus());
        throw new SisException("status " + this.rasrService.getStatus().getStatus() + " can't send end");
    }

    private boolean checkConnect() {
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_ERROR) {
            this.close();
            return true;
        }
        if (this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_INIT || this.rasrService.getStatus() == SisEnum.WebsocketStatus.STATE_CLOSE) {
            return true;
        }
        log.warn("status {} can't connect", (Object)this.rasrService.getStatus().getStatus());
        return false;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }
}

