/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.client;

import com.cloud.sdk.http.HttpMethodName;
import com.huawei.sis.bean.AuthInfo;
import com.huawei.sis.bean.SisConfig;
import com.huawei.sis.bean.request.AsrCustomLongRequest;
import com.huawei.sis.bean.request.AsrCustomShortRequest;
import com.huawei.sis.bean.response.AsrCustomLongResponse;
import com.huawei.sis.bean.response.AsrCustomShortResponse;
import com.huawei.sis.bean.response.JobResp;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.service.HttpService;
import com.huawei.sis.util.JsonUtils;
import com.huawei.sis.util.OKHttpClientUtils;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsrCustomizationClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsrCustomizationClient.class);
    private HttpService service;
    private AuthInfo authInfo;
    private String shortApi;
    private String longApi;

    public AsrCustomizationClient(AuthInfo authInfo) {
        this(authInfo, new SisConfig());
    }

    public AsrCustomizationClient(AuthInfo authInfo, SisConfig config) {
        this.authInfo = authInfo;
        this.service = new HttpService(authInfo, config);
        this.shortApi = "/v1/" + authInfo.getProjectId() + "/asr/short-audio";
        this.longApi = "/v1/" + authInfo.getProjectId() + "/asr/transcriber/jobs";
    }

    public String submitJob(Map<String, String> headers, AsrCustomLongRequest request) throws SisException {
        String params = request.constructParams();
        String url = this.authInfo.getServiceEndPoint() + this.longApi;
        if (headers == null) {
            headers = OKHttpClientUtils.getJsonHeaders();
        }
        String result = this.service.getHttpApiResponse(url, headers, params, HttpMethodName.POST);
        JobResp jobResp = JsonUtils.str2Obj(result, JobResp.class);
        log.debug("Success to get the job id");
        return jobResp.getJobId();
    }

    public String submitJob(AsrCustomLongRequest request) throws SisException {
        return this.submitJob(null, request);
    }

    public AsrCustomLongResponse getAsrLongResponse(Map<String, String> headers, String jobId) throws SisException {
        AsrCustomLongResponse response = null;
        if (headers == null) {
            headers = OKHttpClientUtils.getJsonHeaders();
        }
        StringBuilder sb = new StringBuilder();
        String url = sb.append(this.authInfo.getServiceEndPoint()).append("/v1/").append(this.authInfo.getProjectId()).append("/asr/transcriber/jobs/").append(jobId).toString();
        String result = this.service.getHttpApiResponse(url, headers, null, HttpMethodName.GET);
        response = JsonUtils.str2Obj(result, AsrCustomLongResponse.class);
        return response;
    }

    public AsrCustomLongResponse getAsrLongResponse(String jobId) throws SisException {
        return this.getAsrLongResponse(null, jobId);
    }

    public AsrCustomShortResponse getAsrShortResponse(Map<String, String> headers, AsrCustomShortRequest request) throws SisException {
        AsrCustomShortResponse response = null;
        String params = request.constructParams();
        if (headers == null) {
            headers = OKHttpClientUtils.getJsonHeaders();
        }
        String url = this.authInfo.getServiceEndPoint() + this.shortApi;
        String result = this.service.getHttpApiResponse(url, headers, params, HttpMethodName.POST);
        response = JsonUtils.str2Obj(result, AsrCustomShortResponse.class);
        return response;
    }

    public AsrCustomShortResponse getAsrShortResponse(AsrCustomShortRequest request) throws SisException {
        return this.getAsrShortResponse(null, request);
    }
}

