/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.bean.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VcsCloneRequest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="text")
    private String userInputText;
    @JsonProperty(value="config")
    private VoiceCloneConfig voiceCloneConfig;
    private boolean isSaved = false;
    private String savePath = "data/1.wav";

    public VcsCloneRequest(String voiceName, String text) {
        VoiceCloneConfig config = new VoiceCloneConfig();
        config.voiceName = voiceName;
        config.sampleRate = "16000";
        config.audioFormat = "wav";
        this.userInputText = text;
        this.voiceCloneConfig = config;
    }

    public VcsCloneRequest(String voiceName, String text, String audioFormat, String sampleRate) {
        VoiceCloneConfig config = new VoiceCloneConfig();
        config.voiceName = voiceName;
        config.sampleRate = sampleRate;
        config.audioFormat = audioFormat;
        this.userInputText = text;
        this.voiceCloneConfig = config;
    }

    public String constructParams() throws SisException {
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("text", this.userInputText);
        ObjectNode config = OBJECT_MAPPER.createObjectNode();
        config.put("audio_format", this.voiceCloneConfig.audioFormat);
        config.put("sample_rate", this.voiceCloneConfig.sampleRate);
        config.put("voice_name", this.voiceCloneConfig.voiceName);
        rootNode.set("config", (JsonNode)config);
        return JsonUtils.node2Str((JsonNode)rootNode);
    }

    @Generated
    public String getUserInputText() {
        return this.userInputText;
    }

    @Generated
    public VoiceCloneConfig getVoiceCloneConfig() {
        return this.voiceCloneConfig;
    }

    @Generated
    public boolean isSaved() {
        return this.isSaved;
    }

    @Generated
    public String getSavePath() {
        return this.savePath;
    }

    @JsonProperty(value="text")
    @Generated
    public void setUserInputText(String userInputText) {
        this.userInputText = userInputText;
    }

    @JsonProperty(value="config")
    @Generated
    public void setVoiceCloneConfig(VoiceCloneConfig voiceCloneConfig) {
        this.voiceCloneConfig = voiceCloneConfig;
    }

    @Generated
    public void setSaved(boolean isSaved) {
        this.isSaved = isSaved;
    }

    @Generated
    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class VoiceCloneConfig {
        @JsonProperty(value="audio_format")
        private String audioFormat;
        @JsonProperty(value="sample_rate")
        private String sampleRate;
        @JsonProperty(value="voice_name")
        private String voiceName;

        @JsonProperty(value="audio_format")
        @Generated
        public void setAudioFormat(String audioFormat) {
            this.audioFormat = audioFormat;
        }

        @JsonProperty(value="sample_rate")
        @Generated
        public void setSampleRate(String sampleRate) {
            this.sampleRate = sampleRate;
        }

        @JsonProperty(value="voice_name")
        @Generated
        public void setVoiceName(String voiceName) {
            this.voiceName = voiceName;
        }

        @Generated
        public String getAudioFormat() {
            return this.audioFormat;
        }

        @Generated
        public String getSampleRate() {
            return this.sampleRate;
        }

        @Generated
        public String getVoiceName() {
            return this.voiceName;
        }

        @Generated
        public String toString() {
            return "VcsCloneRequest.VoiceCloneConfig(audioFormat=" + this.getAudioFormat() + ", sampleRate=" + this.getSampleRate() + ", voiceName=" + this.getVoiceName() + ")";
        }
    }
}

