/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.bean.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotWordRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HotWordRequest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private List<String> contents;
    private String name;
    private String description = "";
    private String language = "chinese_mandarin";

    public HotWordRequest(String name, List<String> contents) {
        this.name = name;
        this.contents = contents;
    }

    public String constructParams() throws SisException {
        if (this.contents == null || this.contents.size() == 0) {
            log.error("in hot word request, contents can't be empty");
            throw new SisException("in hot word request, contents can't be empty");
        }
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("name", this.name);
        rootNode.put("description", this.description);
        rootNode.put("language", this.language);
        ArrayNode arrayNode = rootNode.putArray("contents");
        for (int i = 0; i < this.contents.size(); ++i) {
            arrayNode.add(this.contents.get(i));
        }
        return JsonUtils.node2Str((JsonNode)rootNode);
    }

    @Generated
    public List<String> getContents() {
        return this.contents;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }
}

