/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.bean.request;

import com.cloud.sdk.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import java.util.List;
import lombok.Generated;

public class AsrCustomShortRequest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String data;
    private String audioFormat;
    private String property;
    private String addPunc = "no";
    private String digitNorm = "yes";
    private String vocabularyId = "";
    private String needWordInfo = "no";
    private List<String> userWords;
    private String autoLanguageDetect = "no";

    public AsrCustomShortRequest(String data, String audioFormat, String property) {
        this.data = data;
        this.audioFormat = audioFormat;
        this.property = property;
    }

    public String constructParams() throws SisException {
        ObjectNode config = OBJECT_MAPPER.createObjectNode();
        config.put("add_punc", this.addPunc);
        config.put("audio_format", this.audioFormat);
        config.put("property", this.property);
        config.put("digit_norm", this.digitNorm);
        config.put("need_word_info", this.needWordInfo);
        config.put("auto_language_detect", this.autoLanguageDetect);
        if (!StringUtils.isNullOrEmpty((String)this.vocabularyId)) {
            config.put("vocabulary_id", this.vocabularyId);
        }
        if (this.userWords != null && this.userWords.size() > 0) {
            ArrayNode arrayNode = config.putArray("user_words");
            for (String userWord : this.userWords) {
                arrayNode.add(userWord);
            }
        }
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("data", this.data);
        rootNode.set("config", (JsonNode)config);
        return JsonUtils.node2Str((JsonNode)rootNode);
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getAudioFormat() {
        return this.audioFormat;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public String getAddPunc() {
        return this.addPunc;
    }

    @Generated
    public String getDigitNorm() {
        return this.digitNorm;
    }

    @Generated
    public String getVocabularyId() {
        return this.vocabularyId;
    }

    @Generated
    public String getNeedWordInfo() {
        return this.needWordInfo;
    }

    @Generated
    public List<String> getUserWords() {
        return this.userWords;
    }

    @Generated
    public String getAutoLanguageDetect() {
        return this.autoLanguageDetect;
    }

    @Generated
    public void setAddPunc(String addPunc) {
        this.addPunc = addPunc;
    }

    @Generated
    public void setDigitNorm(String digitNorm) {
        this.digitNorm = digitNorm;
    }

    @Generated
    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    @Generated
    public void setNeedWordInfo(String needWordInfo) {
        this.needWordInfo = needWordInfo;
    }

    @Generated
    public void setUserWords(List<String> userWords) {
        this.userWords = userWords;
    }

    @Generated
    public void setAutoLanguageDetect(String autoLanguageDetect) {
        this.autoLanguageDetect = autoLanguageDetect;
    }
}

