/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sis.bean.request;

import com.cloud.sdk.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.huawei.sis.exception.SisException;
import com.huawei.sis.util.JsonUtils;
import lombok.Generated;

public class AsrCustomLongRequest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String dataUrl;
    private String audioFormat;
    private String property;
    private String addPunc = "no";
    private boolean needAnalysis = false;
    private boolean dirization = true;
    private String digitNorm = "yes";
    private String callbackUrl;
    private String channel = "MONO";
    private boolean emotion = true;
    private boolean speed = true;
    private String vocabularyId = "";
    private String needWordInfo = "no";

    public AsrCustomLongRequest(String dataUrl, String audioFormat, String property) {
        this.dataUrl = dataUrl;
        this.audioFormat = audioFormat;
        this.property = property;
    }

    public String constructParams() throws SisException {
        ObjectNode config = OBJECT_MAPPER.createObjectNode();
        config.put("audio_format", this.audioFormat);
        config.put("property", this.property);
        config.put("add_punc", this.addPunc);
        config.put("digit_norm", this.digitNorm);
        if (!StringUtils.isNullOrEmpty((String)this.vocabularyId)) {
            config.put("vocabulary_id", this.vocabularyId);
        }
        if (!StringUtils.isNullOrEmpty((String)this.callbackUrl)) {
            config.put("callback_url", this.callbackUrl);
        }
        if (this.isNeedAnalysis()) {
            ObjectNode analysisInfo = OBJECT_MAPPER.createObjectNode();
            analysisInfo.put("diarization", this.dirization);
            analysisInfo.put("channel", this.channel);
            analysisInfo.put("emotion", this.emotion);
            analysisInfo.put("speed", this.speed);
            config.set("need_analysis_info", (JsonNode)analysisInfo);
        }
        config.put("need_word_info", this.needWordInfo);
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        rootNode.put("data_url", this.dataUrl);
        rootNode.set("config", (JsonNode)config);
        return JsonUtils.node2Str((JsonNode)rootNode);
    }

    @Generated
    public String getDataUrl() {
        return this.dataUrl;
    }

    @Generated
    public String getAudioFormat() {
        return this.audioFormat;
    }

    @Generated
    public String getProperty() {
        return this.property;
    }

    @Generated
    public String getAddPunc() {
        return this.addPunc;
    }

    @Generated
    public boolean isNeedAnalysis() {
        return this.needAnalysis;
    }

    @Generated
    public boolean isDirization() {
        return this.dirization;
    }

    @Generated
    public String getDigitNorm() {
        return this.digitNorm;
    }

    @Generated
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public boolean isEmotion() {
        return this.emotion;
    }

    @Generated
    public boolean isSpeed() {
        return this.speed;
    }

    @Generated
    public String getVocabularyId() {
        return this.vocabularyId;
    }

    @Generated
    public String getNeedWordInfo() {
        return this.needWordInfo;
    }

    @Generated
    public void setAddPunc(String addPunc) {
        this.addPunc = addPunc;
    }

    @Generated
    public void setNeedAnalysis(boolean needAnalysis) {
        this.needAnalysis = needAnalysis;
    }

    @Generated
    public void setDirization(boolean dirization) {
        this.dirization = dirization;
    }

    @Generated
    public void setDigitNorm(String digitNorm) {
        this.digitNorm = digitNorm;
    }

    @Generated
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public void setEmotion(boolean emotion) {
        this.emotion = emotion;
    }

    @Generated
    public void setSpeed(boolean speed) {
        this.speed = speed;
    }

    @Generated
    public void setVocabularyId(String vocabularyId) {
        this.vocabularyId = vocabularyId;
    }

    @Generated
    public void setNeedWordInfo(String needWordInfo) {
        this.needWordInfo = needWordInfo;
    }
}

